package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.dto.ChangeDataDto;
import com.yeejoin.amos.boot.module.jg.api.dto.MultiChangeItemData;
import com.yeejoin.amos.boot.module.jg.api.dto.RequestChangeData;
import com.yeejoin.amos.boot.module.jg.api.entity.JgRegistrationHistory;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.enums.CylinderTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IBizDataChangeHandleStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.IChangeDataProcessStrategy;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;

/**
 * 批量维护使用登记策略实现类
 */
@Component
public class BatchDataChangeProcessStrategy implements IChangeDataProcessStrategy {

    private final JgUseRegistrationServiceImpl useRegistrationService;

    private final JgRegistrationHistoryServiceImpl jgRegistrationHistoryService;

    private final JgUseRegistrationMapper jgUseRegistrationMapper;

    private final SingleDataChangeProcessStrategy singleDataChangeProcessStrategy;

    public BatchDataChangeProcessStrategy(JgUseRegistrationServiceImpl useRegistrationService, JgRegistrationHistoryServiceImpl jgRegistrationHistoryService, JgUseRegistrationMapper jgUseRegistrationMapper, SingleDataChangeProcessStrategy singleDataChangeProcessStrategy) {
        this.useRegistrationService = useRegistrationService;
        this.jgRegistrationHistoryService = jgRegistrationHistoryService;
        this.jgUseRegistrationMapper = jgUseRegistrationMapper;
        this.singleDataChangeProcessStrategy = singleDataChangeProcessStrategy;
    }

    @Override
    public List<ChangeDataDto> handle(Map<String, Object> changeData, String defaultChangeId) {
        JSONObject data = (JSONObject) changeData;
        JSONArray equips = data.getJSONArray(RequestChangeData.multiDataKey);
        List<MultiChangeItemData> items = equips.toJavaList(MultiChangeItemData.class);
        List<ChangeDataDto> allChangeColumns = new ArrayList<>();
        items.forEach(item -> {
            String record = item.getRecord();
            Map<String, Object> itemData = item.getDetail();
            if(itemData != null){
                List<ChangeDataDto> oneEquipChangeColumns = singleDataChangeProcessStrategy.handleOne(itemData, record);
                allChangeColumns.addAll(oneEquipChangeColumns);
            }
        });
        return allChangeColumns;
    }

    @Override
    public Map<String, List<Map<String, Object>>> getDetail(String applyNo, String bizId) {
        Map<String, List<Map<String, Object>>> result = new HashMap<>();
        JgUseRegistration jgUseRegistration = useRegistrationService.getOne(new LambdaQueryWrapper<JgUseRegistration>()
                .eq(JgUseRegistration::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, jgUseRegistration.getSequenceNbr());
        lambda.eq(JgRegistrationHistory::getIsDelete, false);
        JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambda);
        JSONObject jsonObject = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
        List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) jsonObject.get("equipmentLists");
        List<String> records = equipmentLists.stream().map(v -> (String) v.get("record")).collect(toList());
        List<Map<String, Object>> tableData;
        if (CylinderTypeEnum.CYLINDER.getCode().equals(jsonObject.get("EQU_CATEGORY_CODE"))) {
            List<DictionarieValueModel> fillingMedium = Systemctl.dictionarieClient.dictValues("FILLING_MEDIUM").getResult();
            Map<String, Object> fillingMediumMap = fillingMedium.stream().collect(Collectors.toMap(DictionarieValueModel::getDictDataKey, DictionarieValueModel::getDictDataValue));
            tableData = jgUseRegistrationMapper.queryForUnitVesselEquipment(records);
            tableData.forEach(i -> i.put("chargingMedium", fillingMediumMap.get(i.get("chargingMedium"))));
        } else {
            tableData = jgUseRegistrationMapper.queryForUnitPipelineEquipment(records);
        }
        result.put("tableData", tableData);
        return result;
    }


    @Override
    public IBizDataChangeHandleStrategy.ModelType canHandleMode() {
        return IBizDataChangeHandleStrategy.ModelType.batch;
    }
}
