package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IBizDataChangeHandleStrategy;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgDesignInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgFactoryInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgDesignInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgFactoryInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgRegisterInfoMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Service
public class EquipChangeDataUpdateService {

    private final ESEquipmentCategory esEquipmentCategory;

    private final IdxBizJgDesignInfoMapper idxBizJgDesignInfoMapper;

    private final IdxBizJgFactoryInfoMapper jgFactoryInfoMapper;

    private final IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;

    private final CommonMapper commonMapper;

    private final EquipmentCategoryMapper equipmentCategoryMapper;

    public EquipChangeDataUpdateService(ESEquipmentCategory esEquipmentCategory, IdxBizJgDesignInfoMapper idxBizJgDesignInfoMapper, IdxBizJgFactoryInfoMapper jgFactoryInfoMapper, IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper, CommonMapper commonMapper, EquipmentCategoryMapper equipmentCategoryMapper) {
        this.esEquipmentCategory = esEquipmentCategory;
        this.idxBizJgDesignInfoMapper = idxBizJgDesignInfoMapper;
        this.jgFactoryInfoMapper = jgFactoryInfoMapper;
        this.idxBizJgRegisterInfoMapper = idxBizJgRegisterInfoMapper;
        this.commonMapper = commonMapper;
        this.equipmentCategoryMapper = equipmentCategoryMapper;
    }

    public void updateRegisterChangeData(String record, EquipRegisterChangeDataDto registerChangeDataDto) {
        LambdaUpdateWrapper<IdxBizJgRegisterInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgRegisterInfo::getRecord, record);
        updateWrapper.set(!Objects.equals(registerChangeDataDto.getEquCode(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgRegisterInfo::getEquCode, registerChangeDataDto.getEquCode());
        updateWrapper.set(!Objects.equals(registerChangeDataDto.getEquDefine(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgRegisterInfo::getEquDefine, registerChangeDataDto.getEquDefine());
        updateWrapper.set(!Objects.equals(registerChangeDataDto.getProductName(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgRegisterInfo::getProductName, registerChangeDataDto.getProductName());
        updateWrapper.set(!Objects.equals(registerChangeDataDto.getEquType(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgRegisterInfo::getEquType, registerChangeDataDto.getEquType());
        updateWrapper.set(!Objects.equals(registerChangeDataDto.getEquPrice(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgRegisterInfo::getEquPrice, registerChangeDataDto.getEquPrice());
        updateWrapper.set(!Objects.equals(registerChangeDataDto.getProductPhoto(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgRegisterInfo::getProductPhoto, registerChangeDataDto.getProductPhoto());
        updateWrapper.set(!Objects.equals(registerChangeDataDto.getOtherAccessoriesReg(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgRegisterInfo::getOtherAccessoriesReg, registerChangeDataDto.getOtherAccessoriesReg());
        idxBizJgRegisterInfoMapper.update(null, updateWrapper);
        updateRegisterEsData(record, registerChangeDataDto);
    }

    public void updateDesignChangeData(String record, EquipDesignChangeDataDto equipDesignChangeDataDto) {
        LambdaUpdateWrapper<IdxBizJgDesignInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgDesignInfo::getRecord, record);
        updateWrapper.set(!Objects.equals(equipDesignChangeDataDto.getDesignDate(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgDesignInfo::getDesignDate, DateUtil.parse(equipDesignChangeDataDto.getDesignDate(), "yyyy-MM-dd"));
        updateWrapper.set(!Objects.equals(equipDesignChangeDataDto.getDesignDoc(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgDesignInfo::getDesignDoc, equipDesignChangeDataDto.getDesignDoc());
        updateWrapper.set(!Objects.equals(equipDesignChangeDataDto.getDesignUnitCreditCode(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgDesignInfo::getDesignUnitCreditCode, equipDesignChangeDataDto.getDesignUnitCreditCode());
        updateWrapper.set(!Objects.equals(equipDesignChangeDataDto.getDesignUnitName(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgDesignInfo::getDesignUnitName, equipDesignChangeDataDto.getDesignUnitName());
        updateWrapper.set(!Objects.equals(equipDesignChangeDataDto.getDesignUseDate(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgDesignInfo::getDesignUseDate, equipDesignChangeDataDto.getDesignUseDate());
        updateWrapper.set(!Objects.equals(equipDesignChangeDataDto.getDesignLicenseNum(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgDesignInfo::getDesignLicenseNum, equipDesignChangeDataDto.getDesignLicenseNum());
        updateWrapper.set(!Objects.equals(equipDesignChangeDataDto.getAppraisalUnit(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgDesignInfo::getAppraisalUnit, equipDesignChangeDataDto.getAppraisalUnit());
        updateWrapper.set(!Objects.equals(equipDesignChangeDataDto.getOtherAccessoriesDes(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgDesignInfo::getOtherAccessoriesDes, equipDesignChangeDataDto.getOtherAccessoriesDes());
        updateWrapper.set(!Objects.equals(equipDesignChangeDataDto.getAppraisalDate(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgDesignInfo::getAppraisalDate, equipDesignChangeDataDto.getAppraisalDate());
        updateWrapper.set(!Objects.equals(equipDesignChangeDataDto.getDrawingDo(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgDesignInfo::getDrawingDo, equipDesignChangeDataDto.getDrawingDo());
        updateWrapper.set(!Objects.equals(equipDesignChangeDataDto.getDesignStandard(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgDesignInfo::getDesignStandard, equipDesignChangeDataDto.getDesignStandard());
        idxBizJgDesignInfoMapper.update(null, updateWrapper);
    }

    public void updateFactoryChangeData(String record, EquipFactoryChangeDataDto equipFactoryChangeDataDto) {
        LambdaUpdateWrapper<IdxBizJgFactoryInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgFactoryInfo::getRecord, record);
        // 影响设备代码的生成
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getProduceDate(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getProduceDate, DateUtil.parse(equipFactoryChangeDataDto.getProduceDate(), "yyyy-MM-dd"));
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getProduceUnitName(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getProduceUnitName, equipFactoryChangeDataDto.getProduceUnitName());
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getProduceCountry(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getProduceCountry, equipFactoryChangeDataDto.getProduceCountry());
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getProduceUnitCreditCode(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getProduceUnitCreditCode, equipFactoryChangeDataDto.getProduceUnitCreditCode());
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getProduceLicenseNum(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getProduceLicenseNum, equipFactoryChangeDataDto.getProduceLicenseNum());
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getProductQualityYieldProve(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getProductQualityYieldProve, equipFactoryChangeDataDto.getProductQualityYieldProve());
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getFactoryStandard(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getFactoryStandard, equipFactoryChangeDataDto.getFactoryStandard());
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getFactoryNum(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getFactoryNum, equipFactoryChangeDataDto.getFactoryNum());
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getFactSupervisionInspectionReport(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getFactSupervisionInspectionReport, equipFactoryChangeDataDto.getFactSupervisionInspectionReport());
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getOtherAccessoriesFact(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getOtherAccessoriesFact, equipFactoryChangeDataDto.getOtherAccessoriesFact());
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getImported(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getImported, equipFactoryChangeDataDto.getImported());
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getInsUseMaintainExplain(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getInsUseMaintainExplain, equipFactoryChangeDataDto.getInsUseMaintainExplain());
        updateWrapper.set(!Objects.equals(equipFactoryChangeDataDto.getBoilerEnergyEfficiencyCertificate(), IBizDataChangeHandleStrategy.DEFAULT_VALUE), IdxBizJgFactoryInfo::getBoilerEnergyEfficiencyCertificate, equipFactoryChangeDataDto.getBoilerEnergyEfficiencyCertificate());
        jgFactoryInfoMapper.update(null, updateWrapper);
        this.updateFactoryEsData(record, equipFactoryChangeDataDto);
    }

    private void updateFactoryEsData(String record, EquipFactoryChangeDataDto equipFactoryChangeDataDto) {
        // es 数据更新
        Optional<ESEquipmentCategoryDto> optional = esEquipmentCategory.findById(record);
        if (optional.isPresent()) {
            ESEquipmentCategoryDto esEquipmentCategoryDto = optional.get();
            if (!Objects.equals(equipFactoryChangeDataDto.getProduceDate(), IBizDataChangeHandleStrategy.DEFAULT_VALUE)) {
                esEquipmentCategoryDto.setPRODUCE_DATE(equipFactoryChangeDataDto.getProduceDate());
            }
            if (!Objects.equals(equipFactoryChangeDataDto.getFactoryNum(), IBizDataChangeHandleStrategy.DEFAULT_VALUE)) {
                esEquipmentCategoryDto.setFACTORY_NUM(equipFactoryChangeDataDto.getFactoryNum());
            }
            if (!Objects.equals(equipFactoryChangeDataDto.getProduceUnitName(), IBizDataChangeHandleStrategy.DEFAULT_VALUE)) {
                esEquipmentCategoryDto.setPRODUCE_UNIT_NAME(equipFactoryChangeDataDto.getProduceUnitName());
            }
            esEquipmentCategory.save(esEquipmentCategoryDto);
        }
    }

    private void updateRegisterEsData(String record, EquipRegisterChangeDataDto registerChangeDataDto) {
        // es 数据更新
        Optional<ESEquipmentCategoryDto> optional = esEquipmentCategory.findById(record);
        if (optional.isPresent()) {
            ESEquipmentCategoryDto esEquipmentCategoryDto = optional.get();
            esEquipmentCategoryDto.setPRODUCT_NAME(registerChangeDataDto.getProductName());
            esEquipmentCategoryDto.setEQU_CODE(registerChangeDataDto.getEquCode());
            esEquipmentCategoryDto.setEQU_TYPE(registerChangeDataDto.getEquType());
            esEquipmentCategoryDto.setEQU_DEFINE_CODE(registerChangeDataDto.getEquDefine());
            if (StringUtils.isEmpty(registerChangeDataDto.getEquDefine())) {
                esEquipmentCategoryDto.setEQU_DEFINE(null);
            } else {
                EquipmentCategory category = equipmentCategoryMapper.selectOne(new LambdaQueryWrapper<EquipmentCategory>().eq(EquipmentCategory::getCode, registerChangeDataDto.getEquDefine()));
                if (category != null) {
                    esEquipmentCategoryDto.setEQU_DEFINE(category.getName());
                }
            }
            esEquipmentCategory.save(esEquipmentCategoryDto);
        }
    }

    public void updateTechParamByRecord(String tableName, String record, List<ChangeDataDto> changeDataDtos) {
        List<DynamicColumnDto> columns = changeDataDtos.stream().map(c -> {
            DynamicColumnDto columnDto = new DynamicColumnDto();
            columnDto.setColumnName(String.format("\"%s\"", StrUtil.toUnderlineCase(c.getColumnKey()).toUpperCase()));
            columnDto.setColumnValue(c.getColumnNewValue());
            return columnDto;
        }).collect(Collectors.toList());
        //  sql 动态构建入库
        commonMapper.updateTechParamDynamic(tableName, record, columns);
    }
}
