package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.common.api.feign.EquipFeignClient;
import com.yeejoin.amos.boot.module.common.api.mapper.FireTeamMapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.CarStatusInfoDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferCompanyResourcesDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransferCompanyResources;
import com.yeejoin.amos.boot.module.jcs.api.enums.FireCarStatusEnum;
import com.yeejoin.amos.boot.module.jcs.api.mapper.PowerTransferCompanyResourcesMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IPowerTransferCompanyResourcesService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
* 调派单位资源 服务实现类
*
* @author tb
* @date 2021-06-17
*/
@Service
public class PowerTransferCompanyResourcesServiceImpl extends BaseService<PowerTransferCompanyResourcesDto,PowerTransferCompanyResources,PowerTransferCompanyResourcesMapper> implements IPowerTransferCompanyResourcesService {
    @Resource
    PowerTransferCompanyResourcesMapper powerTransferCompanyResourcesMapper;
    @Autowired
    EquipFeignClient equipFeignClient;
    @Override
    public AlertCalled getByPowerTransferCompanyResourId(Long id) {


        QueryWrapper<PowerTransferCompanyResources> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("status", FireCarStatusEnum.执行中.getCode() );
        queryWrapper.eq("resources_id", id.toString() );
        PowerTransferCompanyResources alertFormValue = this.getOne(queryWrapper);
        if(alertFormValue!=null){
            return powerTransferCompanyResourcesMapper.getByPowerTransferCompanyResourId(alertFormValue.getPowerTransferCompanyId());
        }
        return null;
    }

    @Override
    public PowerTransferCompanyResources getByAlertCalledIdCarId(Long alertCalledId, Long carId) {
        return powerTransferCompanyResourcesMapper.getByAlertCalledIdCarId(alertCalledId,carId);
    }

    @Override
    public void updateByAlertCalledId(Long alertCalledId) {
        powerTransferCompanyResourcesMapper.updateByAlertCalledId(alertCalledId);
    }


    @Override
    @Transactional
    public void updatePowerTransferCompanyResourcesService(Long alertCalledId, Long carId, String code,int type , String remarks) {

    PowerTransferCompanyResources powerTransferCompanyResources= powerTransferCompanyResourcesMapper.getByAlertCalledIdCarId(alertCalledId,carId);
        try {

            if(type==2){
                powerTransferCompanyResources.setStatus(code);
                powerTransferCompanyResources.setRemarks(remarks);
                powerTransferCompanyResourcesMapper.updateById(powerTransferCompanyResources);
                List<Object> carStatusInfoDtoList = new ArrayList();
                //修改装备信息
                CarStatusInfoDto carStatusInfo = new CarStatusInfoDto();
                carStatusInfo.setSequenceNbr(carId+"");
                carStatusInfo.setStatus(FireCarStatusEnum.执勤.getCode());
                carStatusInfoDtoList.add(carStatusInfo);
                // 更新所有车辆状态为执勤
                equipFeignClient.updateCarStatus(carStatusInfoDtoList);
            }else{
                powerTransferCompanyResources.setCarStatus(code);
                powerTransferCompanyResources.setRemarks(remarks);
                powerTransferCompanyResourcesMapper.updateById(powerTransferCompanyResources);
            }
        } catch (Exception e) {
            throw  new RuntimeException("修改失败！");
        }


    }
}
