package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import com.yeejoin.equipmanage.common.utils.FileItem;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 社会力量表
 *
 * @author system_generator
 * @date 2024-01-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_social_power")
public class SocialPower extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
	@TableField("id")
    private Long id;

    /**
     * 单位名称
     */
	@TableField("company_name")
    private String companyName;

    /**
     * 所在地
     */
	@TableField("location")
    private String location;

    /**
     * 联系人
     */
	@TableField("contact_user")
    private String contactUser;

    /**
     * 联系电话
     */
	@TableField("contact_phone")
    private String contactPhone;

    /**
     * 到站距离
     */
	@TableField("arrival_distance")
    private String arrivalDistance;

    /**
     * 到站时间
     */
    @TableField("arrival_time")
    private String arrivalTime;

    /**
     * 备注信息
     */
    @TableField("remark")
    private String remark;

    @TableField("biz_org_name")
    private String bizOrgName;

    @TableField("biz_org_code")
    private String bizOrgCode;

    @TableField("power_status")
    private String powerStatus;

    /**
     * 路线图
     */
    @TableField(exist = false)
    private List<FileItem> attachFiles;

    @TableField(exist = false)
    private String statusCode;

}
