package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.dto.EquipTypeAmountPageDTO;
import com.yeejoin.equipmanage.common.entity.vo.EquipTypeImgAmountVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *  Mapper 接口
 *
 */
public interface EmergencyMapper extends BaseMapper{

    /**
     * 应急物资列表
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> selectEmergencyMaterials();

    Map<String, Object> getEmergencyMaterials(@Param("bizOrgCode") String bizOrgCode);

    /**
     * 应急物资详情
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectEmergencyMaterialsDetails(Page<Map<String, Object>> page, @Param("bizOrgCode") String bizOrgCode);

    /**
     * 消防炮列表
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectFireMonitor(Page<Map<String, Object>> page, @Param("bizOrgCode") String bizOrgCode, @Param("code") String code);

    /**
     * 泡沫罐
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectFoamTank(Page<Map<String, Object>> page);

    /**
     * 排油系统
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectOilDrainage(Page<Map<String, Object>> page , @Param("bizOrgCode") String bizOrgCode, @Param("code") String code);


    /**
     * 排油系统
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectOilDrainageNew(Page<Map<String, Object>> page , @Param("bizOrgCode") String bizOrgCode, @Param("code") String code);

    /**
     * 气体灭火系统
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectGasExtinguishing(Page<Map<String, Object>> page , @Param("bizOrgCode") String bizOrgCode, @Param("code") String code);

    /**
     * 压力流量
     * @param page
     * @param bizOrgCode
     * @return
     */
    Page<Map<String, Object>> selectPressureFlow(Page<Map<String, Object>> page , @Param("bizOrgCode") String bizOrgCode);


    List<Map<String, Object>> getSystemState(@Param("bizOrgCode") String bizOrgCode);

    Map<String, Object> getSystemAlarmTheCount(@Param("status") String status,@Param("bizOrgCode")  String bizOrgCode);
    List<Map<String, Object>> getSystemAlarmCount(@Param("status") String status,@Param("current") int current,@Param("size") int size,@Param("bizOrgCode")  String bizOrgCode);

    List<Map<String, Object>> getCAFSWaterTankInfo();

    List<Map<String, Object>> selectAlarmAnalysis(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("dataType")String dataType, @Param("date")String date, @Param("list") List<String> codes);

    List<Map<String, Object>> selectAlarmAnalysisCount( @Param("startDate")String startDate, @Param("endDate")String endDate,@Param("list") List<String> codes);

    Map<String, Object> getSystemAndCarCount();

    List<String> selectSystemCodes(@Param("systemType") String systemType);

    List<Map<String, Object>> selectFireCannonAlarmAnalysisPie(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("list") List<String> codes);

    List<Map<String, Object>> waterSystemAlarmAnalysisPie(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("list") List<String> codes);

    List<Map<String, Object>> waterSystemAlarmAnalysis(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("dataType")String dataType, @Param("date")String date, @Param("list") List<String> codes);

    List<Map<String, Object>> fireCannonSystemAlarmAnalysis(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("dataType")String dataType, @Param("date")String date, @Param("list") List<String> codes);

    List<Map<String, String>> getEquipExpiryList(@Param("expiryDayNum") Integer expiryDayNum);

    Map<String, Integer> getStockEquipStatistics();

    List<Map<String, Object>> getEquipExpiryStatistics(@Param("expiryDayNum") Integer expiryDayNum);

    /**
     *
     * @param page
     * @param bizOrgCode
     * @param types 类型
     * @param emergencyLevels 等级
     * @param name 设备名称
     * @return
     */
    Page<Map<String, Object>> alarmList(@Param("page") Page<Map<String, Object>> page, @Param("bizOrgCode") String bizOrgCode, @Param("systemCode") String systemCode, @Param("types") List<String> types, @Param("emergencyLevels") List<String> emergencyLevels, @Param("name") String name, @Param("cleanStatus") Integer cleanStatus, @Param("handleStatus") Integer handleStatus , @Param("createDate") String createDate , @Param("startDate") String startDate , @Param("endDate") String endDate);

    List<Map<String, Object>> alarmListNoPage( @Param("bizOrgCode") String bizOrgCode, @Param("systemCode") String systemCode, @Param("types") List<String> types, @Param("emergencyLevels") List<String> emergencyLevels, @Param("name") String name, @Param("cleanStatus") Integer cleanStatus, @Param("handleStatus") Integer handleStatus , @Param("createDate") String createDate , @Param("startDate") String startDate , @Param("endDate") String endDate);

    IPage<EquipTypeImgAmountVO> getEmergencyEquipList(@Param("page") IPage page, @Param("equipTypeAmountPage") EquipTypeAmountPageDTO equipTypeAmountPage, @Param("list") List<String> list);

    List<Map<String, Object >> getEquipStatistic(@Param("bizOrgCode") String bizOrgCode, @Param("equipCodeKey") String equipCodeKey);

    List<Map<String, Object >> getAllTypeEquipStatistic(@Param("bizOrgCode") String bizOrgCode, @Param("list") List<String> list);
}
