package com.yeejoin.amos.patrol.business.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.patrol.business.service.intfc.IPlanTaskService;
import com.yeejoin.amos.patrol.business.util.CommonResponse;
import com.yeejoin.amos.patrol.business.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.business.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.annotation.Resource;

@RestController
@RequestMapping("/api/controlScreen")
@Api(value = "管控屏API", tags = "管控屏API")
public class ControlScreenController extends AbstractBaseController {

    @Resource
    private IPlanTaskService iPlanTaskService;

    @GetMapping("/firePatrolStatics")
    @ApiOperation(value = "消防巡检信息统计")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    public CommonResponse firePatrolStatics(@RequestParam(required = false) String bizOrgCode) {
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        }
        return CommonResponseUtil.success(iPlanTaskService.firePatrolStatics(bizOrgCode));
    }

    @GetMapping("/statics")
    @ApiOperation(value = "消防运维信息")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public CommonResponse getStatics(
            @RequestParam(required = false) String companyCode,
            @RequestParam(required = false) String bizOrgCode
    ) {
        if (StringUtils.isEmpty(bizOrgCode)) {
            ReginParams reginParams = getSelectedOrgInfo();
            bizOrgCode = reginParams.getPersonIdentity().getCompanyBizOrgCode();
        }
        return CommonResponseUtil.success(iPlanTaskService.getStatics(companyCode, bizOrgCode));
    }

}
