package com.yeejoin.amos.supervision.business.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.supervision.business.feign.DangerFeignClient;
import com.yeejoin.amos.supervision.business.service.intfc.ICheckReportService;
import com.yeejoin.amos.supervision.core.common.dto.CheckReportParamDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;

@RestController
@RequestMapping(value = "/check/report")
@Api(tags = "消防监督检查报告api")
public class CheckReportController extends BaseController {

    @Autowired
    ICheckReportService iCheckReportService;

    @Autowired
    DangerFeignClient dangerFeignClient;

    /**
     * 分页查询
     *
     * @param queryParam
     * @param current
     * @param size
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分页查询检查报告", notes = "分页查询检查报告")
    @GetMapping(value = "/page")
    public ResponseModel queryPage(@RequestParam int current, @RequestParam int size,
                                   @RequestParam(required = false) String name,
                                   @RequestParam(required = false) String planName,
                                   @RequestParam(required = false) String planCheckType,
                                   @RequestParam(required = false) String checkLevel,
                                   @RequestParam(required = false) String startCheckTime,
                                   @RequestParam(required = false) String endCheckTime,
                                   @RequestParam(required = false) String checkUser) throws ParseException {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getOrgCode(reginParams);
        if (loginOrgCode.contains("-")) {
            loginOrgCode = loginOrgCode.substring(0, loginOrgCode.indexOf("-"));
        }
        CheckReportParamDto queryParam = new CheckReportParamDto();
        queryParam.setName(name);
        queryParam.setPlanName(planName);
        queryParam.setPlanCheckType(planCheckType);
        queryParam.setCheckLevel(checkLevel);
        if (!ValidationUtil.isEmpty(startCheckTime)) {
            queryParam.setStartCheckTime(DateUtils.dateParse(startCheckTime, DateUtils.DATE_TIME_PATTERN));
        }
        if (!ValidationUtil.isEmpty(endCheckTime)) {
            queryParam.setEndCheckTime(DateUtils.dateParse(endCheckTime, DateUtils.DATE_TIME_PATTERN));
        }
        queryParam.setCheckUser(checkUser);
        queryParam.setOrgCode(loginOrgCode);
        Page page = new Page<>(current, size);
        return ResponseHelper.buildResponse(iCheckReportService.pageList(page, queryParam));
    }

    /**
     * 分页查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询检查报告详情", notes = "查询检查报告详情")
    @GetMapping(value = "/detail/{id}")
    public ResponseModel getDetailById(@PathVariable(value = "id") String id) {
        return ResponseHelper.buildResponse(iCheckReportService.getDetailById(id));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取检查报告文档", notes = "获取检查报告文档")
    @GetMapping(value = "/docx/{id}")
    public void getCheckReportDocx(HttpServletResponse response, @PathVariable(name = "id") String reportId) throws Exception {
        iCheckReportService.getCheckReportDocx(response, reportId);
    }
}
