package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.PersonQualificationsAttachment;
import com.yeejoin.precontrol.common.mapper.PersonQualificationsAttachmentMapper;
import com.yeejoin.precontrol.common.service.IPersonQualificationsAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 人员资质信息附件 服务实现类
 *
 * @author duanwei
 * @date 2020-06-30
 */
@Service
public class PersonQualificationsAttachmentServiceImpl
        extends ServiceImpl<PersonQualificationsAttachmentMapper, PersonQualificationsAttachment>
        implements IPersonQualificationsAttachmentService {
    @Autowired
    PersonQualificationsAttachmentMapper qualificAttachMapper;
    @Value("${fileserver.domain}")
    String fileServerUrl;

    @Override
    public void saveAttach(Long id, List<PersonQualificationsAttachment> attachment) {
        qualificAttachMapper
                .delete(new QueryWrapper<PersonQualificationsAttachment>().eq("person_qualifications_id", id));
        if (attachment != null) {
            attachment.forEach(a -> {
                a.setPersonQualificationsId(id);
                if (a.getAttachment() != null) {
                    a.setAttachment(a.getAttachment().replace(fileServerUrl, ""));
                }
                qualificAttachMapper.insert(a);
            });
        }
    }
}
