package com.yeejoin.amos.maintenance.business.service.intfc;

import com.yeejoin.amos.maintenance.business.entity.mybatis.CheckChkExListBo;
import com.yeejoin.amos.maintenance.business.param.CheckPtListPageParam;
import com.yeejoin.amos.maintenance.business.param.PlanTaskPageParam;
import com.yeejoin.amos.maintenance.business.vo.PlanTaskVo;
import com.yeejoin.amos.maintenance.core.common.request.CommonPageable;
import com.yeejoin.amos.maintenance.dao.entity.PlanTask;
import org.springframework.data.domain.Page;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IPlanTaskService {


    /**
     * 计划执行查询
     */
    Page<HashMap<String, Object>> getPlanTaskInfo(PlanTaskPageParam params);

    /**
     * 计划执行重做
     */
    void reGenPlanTask(HashMap<String, Object> param) throws ParseException;

    /**
     * 计划执行删除
     */
    void planTaskDet(String[] strArry);

    /**
     * 执行计划导出
     */
    List<PlanTaskVo> planTaskReport(String toke, String product, String appKey, PlanTaskPageParam params);

    /**
     * 定时任务发送消息执行中的消息
     *
     * @param runDate
     */
    void taskMessage(String runDate);

    /**
     * 自动任务执行
     *
     * @param runDate
     */
    void taskExecution(String runDate);

    /**
     * 根据路线id获取关联的所有计划任务
     *
     * @param routeId
     * @return
     */
    List<PlanTask> getPlanTaskByRouteId(Long routeId);

    /**
     * 停用计划任务
     *
     * @param routeIds
     */
    void disablePlanTask(Long[] routeIds);


    /**
     * 计划任务列表
     *
     * @param params
     * @param page
     * @return
     */
    Page<Map<String, Object>> getPlanTasks(Map<String, Object> params, CommonPageable page);


    /**
     * 根据计划ID获取所有的 任务计划巡检点
     *
     * @param param
     * @return
     */
    List<Map<String,Object>> getPlanTaskPoints(Map<String, Object> param);

    /**
     * 今日执行情况
     *
     * @param params
     * @return
     */
    Page<CheckChkExListBo> getChkExList(String toke, String product, String appKey, CheckPtListPageParam params);

    /**
     * 根据id获取执行计划
     *
     * @param ids
     * @return
     */
    List<PlanTaskVo> getPlanTaskListByIds(String toke, String product, String appKey, Long[] ids);

    /**
     * 获取公司计划累计情况
     *
     * @param loginOrgCode
     * @return
     */
    String getCumulativePlanCountByOrgCode(String loginOrgCode);


    PlanTask selectPlanTaskStatus(Long id);


    void initPlanStatusOrGenDate();

    /**
     * 任务点详情
     *
     * @param planTaskDetailId 子表id
     * @param routePointId     关系表id
     * @return Map<String, Object>
     */
    Map<String, Object> planTaskPointDetail(String planTaskDetailId, String routePointId);
}
