package com.yeejoin.amos.patrol.business.dao.mapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.yeejoin.amos.patrol.business.param.RoutePageParam;
import com.yeejoin.amos.patrol.business.vo.PointInputItemVo;
import com.yeejoin.amos.patrol.core.common.request.RoutePointInputItemRequest;
import com.yeejoin.amos.patrol.core.common.response.RoutePointRespone;
import com.yeejoin.amos.patrol.core.common.response.RouteResponse;
import com.yeejoin.amos.patrol.dao.entity.InputItem;
import com.yeejoin.amos.patrol.dao.entity.Point;
import com.yeejoin.amos.patrol.dao.entity.PointInputItem;
import com.yeejoin.amos.patrol.dao.entity.Route;
import com.yeejoin.amos.patrol.dao.entity.RoutePointItem;

public interface RouteMapper extends BaseMapper {

	/**
	 * 根据路线id与点id，获取路线上点的项
	 * 
	 * @param routeId
	 * @param pointId
	 * @return
	 */
	List<PointInputItemVo> getInputItemById(@Param(value="routeId") long routeId, @Param(value="pointId") long pointId);
	
	/**
	 * 根据路线id与点id，获取路线点项
	 * 
	 * @param routeId
	 * @param pointId
	 * @return
	 */
	List<PointInputItem> getRoutePointInputItem(@Param(value="routeId") long routeId, @Param(value="pointId") long pointId);
	
	/**
	 * 根据巡检点查询使用到该点的路线名称
	 * 
	 * @param pointId
	 * @return
	 */
	List<String> getRouteNameByPointId(@Param(value="pointId") long pointId);
	
	/**
	 * 返回路线总数
	 * @return
	 */
	Long countRoute(RoutePageParam param);
	
	/**
	 * 根据参数获取路线信息列表
	 * @param param
	 * @return
	 */
	List<HashMap<String, Object>> getRouteInfo(RoutePageParam param);
	
	/**
	 * 删除p_route_point_item by p_input_item
	 * @param ids
	 */
	void deleteReleInputItem(String[] ids);

	/**
	 *	 手机查询巡检路线列表
	 * @param orgCode
	 * @return
	 */
	List<HashMap<String, Object>> queryRouteListByOrgCode(@Param("orgCode") String orgCode,@Param("userId") String userId,@Param("deptId") String deptId);

	/**
	 * 获取路线巡检点个数
	 * @param param
	 * @return
	 */
	long queryRoutePointsCount(HashMap<String, Object> param);

	/**
	 * 获取路线巡检点
	 * @param param
	 * @return
	 */
	List<Map<String, Object>> queryRoutePoints(HashMap<String, Object> param);
	
	List<RoutePointRespone> queryRoutePointsByCondition(HashMap<String, Object> param);
	
	/**
	 * 	查询路线巡检项
	 * @param param
	 * @return
	 */
	public List<RoutePointItem> queryRoutePointItem(HashMap<String, Object> param);

	/**
	 * 获取路线同步信息
	 * @param routeId
	 * @return
	 */
	List<Map<String, Object>> getRouteInfoList(Long routeId);
	
	List<HashMap<String, Object>> queryRoutePointItemByCondition(RoutePointInputItemRequest request);
	
	List<Route> queryRoutesByOrgCode(@Param("orgCode") String orgCode);
}
