package com.yeejoin.amos.api.openapi.face.service;

import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.SpecialBoilerModel;
import com.yeejoin.amos.api.openapi.face.model.SpecialConstructionInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.SpecialConstructionInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.SpecialConstructionInfo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 设备施工告知信息 服务类
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@Component
public class SpecialConstructionInfoService extends
                BaseService<SpecialConstructionInfoModel, SpecialConstructionInfo, SpecialConstructionInfoMapper> {

        /**
         * 分页查询
         */
        public Page<SpecialConstructionInfoModel> queryForTmSpecialConstructionInfoPage(Page page,
                        String agencyCode) {
                return this.queryForPage(page, null, false, agencyCode);
        }

        /**
         * 列表查询 示例
         */
        public List<SpecialConstructionInfoModel> queryForTmSpecialConstructionInfoList(String agencyCode) {
                return this.queryForList("", false, agencyCode);
        }

		public String createSpecialConstructionInfo(List<SpecialConstructionInfoModel> model) {
			// TODO Auto-generated method stub
			if (ValidationUtil.isEmpty(model))
				throw new BadRequest("设备施工告知信息数据为空.");
	    	
			for (SpecialConstructionInfoModel specialConstructionInfoModel : model) {
				specialConstructionInfoModel.setRecDate(new Date());
				specialConstructionInfoModel.setAppId(getAppId());
				this.createWithModel(specialConstructionInfoModel);
			}
			return "OK";
		}
		private String getAppId() {
			String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
	    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
	    	return bizTokenModel.getAppId();
		}
	    @Autowired
	    private RedisTemplate redisTemplate;
}
