package com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler;

import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.typeHandler.DictTypeHandler;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 业务字典处理器
 */
@Component("cbDataDictTypeHandler")
public class CbDataDictTypeHandler implements DictTypeHandler {

    private final DataDictionaryServiceImpl dataDictionaryService;

    private final Map<String, String> cache = new ConcurrentHashMap<>();

    protected CbDataDictTypeHandler(DataDictionaryServiceImpl dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    @Override
    public String handle(String dictType, String dictCode) {
        String key = dictType + "_" + dictCode;
        return cache.computeIfAbsent(key, (k) -> {
            DataDictionary dataDictionary = dataDictionaryService.getByCode(dictCode, dictType);
            return Optional.ofNullable(dataDictionary).map(DataDictionary::getName).orElse(null);
        });
    }


}
