/*
Navicat MySQL Data Transfer

Source Server         : 172.16.11.33
Source Server Version : 50717
Source Host           : 172.16.11.33:3306
Source Database       : pt_patrol

Target Server Type    : MYSQL
Target Server Version : 50717
File Encoding         : 65001

Date: 2020-04-20 15:09:53
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for databasechangelog
-- ----------------------------
DROP TABLE IF EXISTS `databasechangelog`;
CREATE TABLE `databasechangelog` (
  `ID` varchar(255) NOT NULL,
  `AUTHOR` varchar(255) NOT NULL,
  `FILENAME` varchar(255) NOT NULL,
  `DATEEXECUTED` datetime NOT NULL,
  `ORDEREXECUTED` int(11) NOT NULL,
  `EXECTYPE` varchar(10) NOT NULL,
  `MD5SUM` varchar(35) DEFAULT NULL,
  `DESCRIPTION` varchar(255) DEFAULT NULL,
  `COMMENTS` varchar(255) DEFAULT NULL,
  `TAG` varchar(255) DEFAULT NULL,
  `LIQUIBASE` varchar(20) DEFAULT NULL,
  `CONTEXTS` varchar(255) DEFAULT NULL,
  `LABELS` varchar(255) DEFAULT NULL,
  `DEPLOYMENT_ID` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for databasechangeloglock
-- ----------------------------
DROP TABLE IF EXISTS `databasechangeloglock`;
CREATE TABLE `databasechangeloglock` (
  `ID` int(11) NOT NULL,
  `LOCKED` bit(1) NOT NULL,
  `LOCKGRANTED` datetime DEFAULT NULL,
  `LOCKEDBY` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_app_version
-- ----------------------------
DROP TABLE IF EXISTS `p_app_version`;
CREATE TABLE `p_app_version` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `version` varchar(255) DEFAULT NULL COMMENT '版本号',
  `remark` longtext COMMENT '说明',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `publisher` int(255) DEFAULT NULL COMMENT '发布者id',
  `publisher_name` varchar(255) DEFAULT NULL COMMENT '发布者名称',
  `update_type` int(11) DEFAULT NULL COMMENT '版本更新类型：1.强制更新，2.非强制更新',
  `is_latest_version` bit(1) DEFAULT NULL COMMENT '是否为最新版本',
  `url` longtext COMMENT 'app文件保存路径',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_catalog_tree
-- ----------------------------
DROP TABLE IF EXISTS `p_catalog_tree`;
CREATE TABLE `p_catalog_tree` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `name` varchar(100) NOT NULL COMMENT '分类名称',
  `order_no` int(11) NOT NULL COMMENT '排序号',
  `parent_id` bigint(20) NOT NULL COMMENT '上级分类id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=100016 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_check
-- ----------------------------
DROP TABLE IF EXISTS `p_check`;
CREATE TABLE `p_check` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录编号',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `user_id` varchar(200) NOT NULL COMMENT '巡检人id，有可能有多个以,隔开',
  `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
  `point_name` varchar(500) DEFAULT '' COMMENT '巡检点名称',
  `check_time` datetime DEFAULT NULL COMMENT '检查时间',
  `upload_time` datetime DEFAULT NULL COMMENT '记录上传时间',
  `error` varchar(1000) DEFAULT NULL COMMENT '不合格项目',
  `device_id` varchar(100) DEFAULT NULL COMMENT '设备编号',
  `longitude` varchar(50) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(50) DEFAULT NULL COMMENT '纬度',
  `address` varchar(500) DEFAULT NULL COMMENT '参考地址',
  `shot_number` int(11) NOT NULL COMMENT '拍照数量',
  `remark` varchar(1000) DEFAULT NULL COMMENT '巡检备注说明',
  `plan_task_id` bigint(20) DEFAULT NULL COMMENT '计划执行编号',
  `route_id` bigint(20) DEFAULT NULL COMMENT '路线编号',
  `route_name` varchar(500) DEFAULT '' COMMENT '线路名称',
  `is_ok` varchar(6) DEFAULT NULL COMMENT '是否合格',
  `score` int(11) DEFAULT NULL COMMENT '评分',
  `plan_id` bigint(20) DEFAULT NULL COMMENT '计划编号',
  `plan_name` varchar(500) DEFAULT '' COMMENT '计划名称',
  `check_mode` varchar(10) DEFAULT NULL COMMENT '巡检方式',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `plan_task_detail_id` bigint(20) DEFAULT NULL COMMENT '执行计划详情id',
  `error_classify` varchar(200) DEFAULT NULL COMMENT '不合格检查项分类',
  `user_name` varchar(200) DEFAULT '' COMMENT '执行人名称',
  `dep_id` varchar(200) DEFAULT '' COMMENT '执行部门ids',
  `dep_name` varchar(200) DEFAULT '' COMMENT '执行部门名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `plan_task_id` (`plan_task_id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `complex_id_index` (`user_id`,`point_id`,`plan_task_id`,`route_id`,`plan_id`,`plan_task_detail_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=35779 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_check_input
-- ----------------------------
DROP TABLE IF EXISTS `p_check_input`;
CREATE TABLE `p_check_input` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检记录检查项id',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `check_id` bigint(20) NOT NULL COMMENT '巡检记录id',
  `input_id` bigint(20) NOT NULL COMMENT '检查项id',
  `order_no` int(11) NOT NULL COMMENT '序号',
  `input_value` varchar(1000) DEFAULT NULL COMMENT '输入值',
  `is_ok` varchar(6) NOT NULL COMMENT '是否合格',
  `score` int(11) NOT NULL COMMENT '评分',
  `route_point_item_id` bigint(20) DEFAULT NULL COMMENT '巡检点检查项id',
  `remark` varchar(500) DEFAULT NULL,
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `point_classify_id` bigint(20) DEFAULT NULL COMMENT '检查点扩展分类id',
  `point_classify_name` varchar(100) DEFAULT NULL COMMENT '检查点扩展分类名称',
  `input_name` varchar(1000) DEFAULT NULL COMMENT '检查项名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `check_id` (`check_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10172711 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_check_shot
-- ----------------------------
DROP TABLE IF EXISTS `p_check_shot`;
CREATE TABLE `p_check_shot` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录照片编号',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `check_id` bigint(20) NOT NULL COMMENT '巡检记录id',
  `check_input_id` bigint(20) DEFAULT NULL,
  `shot_type` varchar(4) NOT NULL COMMENT '拍照类型',
  `photo_data` text COMMENT '照片内容',
  `point_name` varchar(100) DEFAULT NULL COMMENT '拍照点名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=774 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_config
-- ----------------------------
DROP TABLE IF EXISTS `p_config`;
CREATE TABLE `p_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '配置接口id',
  `des` varchar(50) DEFAULT NULL COMMENT '描述',
  `name` varchar(100) NOT NULL COMMENT '名称',
  `attribute` varchar(500) NOT NULL COMMENT '属性',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_input_item
-- ----------------------------
DROP TABLE IF EXISTS `p_input_item`;
CREATE TABLE `p_input_item` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL,
  `name` varchar(200) NOT NULL,
  `order_no` int(11) NOT NULL,
  `item_type` varchar(50) NOT NULL,
  `is_must` varchar(2) DEFAULT NULL,
  `is_score` varchar(2) NOT NULL,
  `default_value` varchar(100) DEFAULT NULL,
  `is_multiline` varchar(2) DEFAULT NULL,
  `catalog_id` bigint(20) DEFAULT NULL,
  `input_json` longtext,
  `data_json` longtext,
  `remark` longtext,
  `picture_json` longtext,
  `create_by` varchar(255) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `level` varchar(10) DEFAULT NULL COMMENT '巡检项等级1-5',
  `item_no` varchar(100) NOT NULL COMMENT '检查项编号',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  `basis_json` text COMMENT '标准依据',
  `risk_desc` varchar(500) DEFAULT '' COMMENT '风险描述',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10010346 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_measures
-- ----------------------------
DROP TABLE IF EXISTS `p_measures`;
CREATE TABLE `p_measures` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '管控措施编号',
  `level` varchar(10) DEFAULT NULL COMMENT '风险等级',
  `accident_type` text COMMENT '事故类型',
  `point_id` bigint(20) DEFAULT NULL COMMENT '风险点id',
  `update_by` varchar(255) DEFAULT NULL COMMENT '更新用户id',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `engineering` text COMMENT '工程措施',
  `management` text COMMENT '管理措施',
  `train` text COMMENT '培训教育',
  `protection` text COMMENT '个体防护',
  `disposal` text COMMENT '应急处置',
  `is_del` int(11) DEFAULT '0' COMMENT '是否删除',
  `risk_factors` text COMMENT '风险因素',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_msg
-- ----------------------------
DROP TABLE IF EXISTS `p_msg`;
CREATE TABLE `p_msg` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '公司orgCode',
  `title` varchar(255) NOT NULL COMMENT '消息标题',
  `body` text NOT NULL COMMENT '内容',
  `msg_type` varchar(255) NOT NULL COMMENT '消息类型',
  `status` int(4) DEFAULT NULL COMMENT '发送状态',
  `send_time` datetime DEFAULT NULL COMMENT '发送时间',
  `relation_id` bigint(20) DEFAULT NULL COMMENT '关联id',
  `is_immediately` bit(1) DEFAULT b'1' COMMENT '是否立即发送',
  `fixed_time` datetime DEFAULT NULL COMMENT '定点发送时间',
  `create_by` varchar(255) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_read` bit(1) DEFAULT b'0' COMMENT '是否已读',
  `target_tel` varchar(500) DEFAULT NULL,
  `reciver_name` varchar(255) DEFAULT NULL COMMENT '接受人名称',
  `user_id` varchar(255) DEFAULT NULL COMMENT '接收人id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5006 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_msg_subscribe
-- ----------------------------
DROP TABLE IF EXISTS `p_msg_subscribe`;
CREATE TABLE `p_msg_subscribe` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(50) NOT NULL COMMENT '公司code',
  `user_id` varchar(255) NOT NULL COMMENT '用户ID',
  `msg_type` varchar(255) NOT NULL COMMENT '消息类型',
  `attribute1` varchar(255) DEFAULT NULL COMMENT '属性1',
  `attribute2` varchar(255) DEFAULT NULL COMMENT '属性2',
  `attribute3` varchar(255) DEFAULT NULL COMMENT '属性3',
  `attribute4` varchar(255) DEFAULT NULL COMMENT '属性4',
  `attribute5` varchar(255) DEFAULT NULL COMMENT '属性5',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=447 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_plan
-- ----------------------------
DROP TABLE IF EXISTS `p_plan`;
CREATE TABLE `p_plan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '计划编号',
  `name` varchar(100) NOT NULL COMMENT '计划名称',
  `org_code` varchar(100) NOT NULL COMMENT '公司Id',
  `dept_id` varchar(225) DEFAULT NULL COMMENT '部门id',
  `route_id` bigint(20) NOT NULL COMMENT '路线编号',
  `plan_type` varchar(50) NOT NULL COMMENT '计划类型：1-日，2-周，3-月，4-年',
  `is_fixed_date` varchar(2) NOT NULL COMMENT '是否固定巡检日期：0-否；1-是',
  `in_order` varchar(2) DEFAULT '0' COMMENT '是否必须按照顺序执行：0-否；1-是',
  `plan_begin` date DEFAULT NULL COMMENT '计划开始日期',
  `plan_end` date DEFAULT NULL COMMENT '计划结束日期',
  `day_rate` int(11) DEFAULT NULL COMMENT '每天频率：0-一次；1-多次',
  `day_time` time DEFAULT NULL COMMENT '开始时间（执行频率为一次时，使用）',
  `day_interval` int(11) DEFAULT NULL COMMENT '执行间隔（每天执行频率为多次时使用）',
  `day_interval_unit` varchar(50) DEFAULT NULL COMMENT '执行间隔单位：1-小时，2-分钟，3-秒',
  `day_begin` time DEFAULT NULL COMMENT '开始时间',
  `day_end` time DEFAULT NULL COMMENT '结束时间',
  `execute_interval` int(11) DEFAULT NULL COMMENT '执行间隔',
  `month_type` varchar(50) DEFAULT NULL COMMENT '月执行类型：1-第，2-在',
  `what_day` varchar(50) DEFAULT NULL COMMENT '哪一天',
  `what_week` int(11) DEFAULT NULL COMMENT '第几周',
  `week_day` int(11) DEFAULT NULL COMMENT '周几',
  `duration` int(11) DEFAULT NULL COMMENT '工作时长（分钟）',
  `user_id` varchar(500) DEFAULT NULL COMMENT '用户编号',
  `execute_rate` int(11) DEFAULT NULL COMMENT '执行频率（年计划使用）',
  `week_begin_num` int(11) DEFAULT NULL COMMENT '开始编号',
  `week_end_num` int(11) DEFAULT NULL COMMENT '结束编号',
  `min_space` int(11) DEFAULT NULL COMMENT '最少间隔',
  `is_score` varchar(2) DEFAULT NULL COMMENT '是否评分',
  `score_formula` varchar(512) DEFAULT NULL COMMENT '评分计算公式',
  `status` tinyint(4) DEFAULT '0' COMMENT '状态:0-正常；1-已停用',
  `error` bigint(10) DEFAULT '0' COMMENT '允许误差(分钟)',
  `next_gen_date` date DEFAULT NULL COMMENT '下次任务生成日期',
  `create_by` int(11) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `last_upd_by` int(11) DEFAULT NULL COMMENT '最近更新者',
  `last_upd_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '最近更新时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `remark1` varchar(255) DEFAULT NULL COMMENT '备注1',
  `remark2` varchar(255) DEFAULT NULL COMMENT '备注2',
  `first_flag` int(4) DEFAULT '0' COMMENT '初始状态标识：0-首次 1-其他',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  `plan_task_id` bigint(20) DEFAULT '0' COMMENT '最新任务id',
  `is_single_execution` bit(1) DEFAULT b'0' COMMENT '是否单人执行:0多人执行；1单人执行',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_org_code_route_id` (`org_code`,`route_id`) USING BTREE,
  KEY `idx_is_stop_next_gen_date` (`status`,`next_gen_date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=338 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_plan_exec_statistics
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_exec_statistics`;
CREATE TABLE `p_plan_exec_statistics` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `check_time` varchar(40) NOT NULL COMMENT '巡检日期',
  `org_code` varchar(40) NOT NULL COMMENT '用户编码',
  `user_id` bigint(11) NOT NULL COMMENT '用户ID',
  `plan_task_num` int(11) DEFAULT NULL COMMENT '计划执行个数',
  `exec_plan_task_num` int(11) DEFAULT '0' COMMENT '计划执行完成个数',
  `missed_check_num` int(11) DEFAULT '0' COMMENT '漏检个数',
  `outside_plan_num` int(11) DEFAULT '0' COMMENT '计划外执行个数',
  PRIMARY KEY (`id`,`org_code`,`user_id`,`check_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3026 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_plan_task
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_task`;
CREATE TABLE `p_plan_task` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '批次号',
  `batch_no` bigint(20) NOT NULL COMMENT '计划批次号',
  `org_code` varchar(100) NOT NULL COMMENT '公司Id',
  `plan_id` bigint(20) NOT NULL COMMENT '计划编号',
  `route_id` bigint(20) DEFAULT NULL COMMENT '路线编号',
  `user_id` varchar(100) DEFAULT NULL COMMENT '用户编号',
  `point_num` int(11) DEFAULT NULL COMMENT '巡检点数',
  `finish_num` int(11) DEFAULT '0' COMMENT '已完成巡检点数',
  `check_date` date DEFAULT NULL COMMENT '巡检日期',
  `begin_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `finish_status` int(4) DEFAULT '0' COMMENT '完成状态：0-未开始；1-进行中;2-已结束；3-已超时',
  `status` int(4) DEFAULT '0' COMMENT '状态：0-有效；1-无效',
  `in_order` varchar(2) DEFAULT '0' COMMENT '是否必须按照顺序执行：0-否；1-是',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `plan_id` (`plan_id`) USING BTREE,
  KEY `begin_time` (`begin_time`) USING BTREE,
  KEY `end_time` (`end_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2339 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_plan_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_task_detail`;
CREATE TABLE `p_plan_task_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务明细编号',
  `task_no` bigint(20) NOT NULL COMMENT '批次号',
  `point_id` bigint(20) NOT NULL COMMENT '点编号',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_finish` int(11) DEFAULT '0' COMMENT '是否完成：0-未完成，1-已完成，2-超时漏检',
  `status` varchar(50) DEFAULT '合格' COMMENT '状态',
  `executor_id` bigint(20) DEFAULT '0' COMMENT '执行人id',
  `executor_date` datetime DEFAULT NULL COMMENT '执行时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `task_no` (`task_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=46177 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_point
-- ----------------------------
DROP TABLE IF EXISTS `p_point`;
CREATE TABLE `p_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '点id',
  `route_id` varchar(1000) DEFAULT NULL COMMENT '路线id',
  `route_name` varchar(1000) DEFAULT NULL COMMENT '路线名称',
  `name` varchar(100) NOT NULL COMMENT '点名称',
  `point_no` varchar(100) NOT NULL COMMENT '点编号',
  `remark` varchar(1000) DEFAULT NULL COMMENT '备注说明',
  `save_gps` varchar(10) DEFAULT NULL COMMENT '是否保存地理信',
  `distance` int(11) DEFAULT NULL COMMENT '有效巡检距离',
  `usually_shot` varchar(10) DEFAULT NULL COMMENT '是否允许普通拍照',
  `shot_min_number` int(11) NOT NULL COMMENT '最小拍照数',
  `shot_max_number` int(11) NOT NULL COMMENT '最大拍照数',
  `fixed_shot` int(11) NOT NULL COMMENT '定点拍照数',
  `latitude` varchar(50) DEFAULT NULL COMMENT '经度',
  `longitude` varchar(50) DEFAULT NULL COMMENT '纬度',
  `address` varchar(1000) DEFAULT NULL COMMENT '参考地址',
  `offline` bit(1) DEFAULT NULL COMMENT '是否允许离线巡检:0不支持1支持',
  `is_fixed` varchar(50) DEFAULT NULL COMMENT '是否为固定',
  `catalog_id` int(11) DEFAULT NULL COMMENT '分类编号',
  `extend_json` longtext COMMENT '扩展字段',
  `is_score` varchar(50) DEFAULT NULL COMMENT '无计划巡检是否评分',
  `level` varchar(100) NOT NULL DEFAULT '1' COMMENT '风险等级',
  `last_update_time` datetime DEFAULT NULL COMMENT '最新更新时间',
  `creator_id` varchar(255) NOT NULL COMMENT '创建用户id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `coordinates` varchar(100) DEFAULT NULL COMMENT '3维坐标',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `charge_dept_id` varchar(255)  DEFAULT '0' COMMENT '责任部门id',
  `charge_person_id` varchar(255)  COMMENT '负责人id',
  `status` varchar(50) DEFAULT '0' COMMENT '状态：0 未纳入巡检，1 合格；2 不合格；3 漏检',
  `floor` int(4) DEFAULT '1' COMMENT '3维模型楼层',
  `error` varchar(1000) DEFAULT NULL COMMENT '最新不合格信息',
  `check_time` datetime DEFAULT NULL COMMENT '最新检查时间',
  `is_indoor` bit(1) DEFAULT b'0' COMMENT '是否室内：0表示室外，1表示室内',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  `risk_source_id` bigint(20) DEFAULT '0' COMMENT '风险区域id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1517 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_point_classify
-- ----------------------------
DROP TABLE IF EXISTS `p_point_classify`;
CREATE TABLE `p_point_classify` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检点分类id',
  `point_id` bigint(20) NOT NULL COMMENT '点id',
  `name` varchar(100) NOT NULL COMMENT '点分类名称',
  `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `order_no` int(11) DEFAULT NULL COMMENT '排序号',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1326 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_point_config
-- ----------------------------
DROP TABLE IF EXISTS `p_point_config`;
CREATE TABLE `p_point_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(1000) DEFAULT NULL COMMENT '转发名称',
  `point_id` bigint(20) DEFAULT NULL COMMENT '巡检点ID',
  `point_code` varchar(255) DEFAULT NULL COMMENT '点编码',
  `infomation_address` int(20) DEFAULT NULL COMMENT '转发信息地址依次递增（唯一）',
  `status` bit(1) DEFAULT NULL COMMENT '巡检点状态（code=0时，status=1漏检，status=0正常；code=1时，status=1不合格，status=0合格）',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否已经删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=529 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_point_inputitem
-- ----------------------------
DROP TABLE IF EXISTS `p_point_inputitem`;
CREATE TABLE `p_point_inputitem` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
  `input_item_id` bigint(20) NOT NULL COMMENT '巡检项id',
  `classify_ids` varchar(255) DEFAULT NULL COMMENT '点分类id集合',
  `order_no` int(11) DEFAULT NULL COMMENT '排序号',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8814 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_point_photo
-- ----------------------------
DROP TABLE IF EXISTS `p_point_photo`;
CREATE TABLE `p_point_photo` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检点图片编号',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
  `order_no` int(11) NOT NULL COMMENT '序号',
  `photo_path` varchar(200) DEFAULT NULL COMMENT '图片路径',
  `file_name` varchar(200) DEFAULT NULL COMMENT '图片名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_route
-- ----------------------------
DROP TABLE IF EXISTS `p_route`;
CREATE TABLE `p_route` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检路线id',
  `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `name` varchar(50) NOT NULL COMMENT '路线名称',
  `boss` varchar(255) DEFAULT NULL COMMENT '负责人',
  `tel` varchar(50) DEFAULT NULL COMMENT '联系电话',
  `remark` varchar(1000) DEFAULT NULL COMMENT '备注说明',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `coordinates` varchar(500) DEFAULT NULL COMMENT '路线3维坐标',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `dept_id` varchar(255) DEFAULT '0',
  `user_id` varchar(255) DEFAULT '0',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=271 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_route_point
-- ----------------------------
DROP TABLE IF EXISTS `p_route_point`;
CREATE TABLE `p_route_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL COMMENT '权限org code',
  `route_id` bigint(20) NOT NULL COMMENT '路线id',
  `point_id` bigint(20) NOT NULL COMMENT '点id',
  `order_no` int(11) DEFAULT '0' COMMENT '排序',
  `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2606 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_route_point_item
-- ----------------------------
DROP TABLE IF EXISTS `p_route_point_item`;
CREATE TABLE `p_route_point_item` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `route_point_id` bigint(20) NOT NULL COMMENT '路线点id',
  `order_no` int(11) DEFAULT NULL COMMENT '排序号',
  `point_input_item_id` bigint(20) DEFAULT NULL COMMENT '检查点-项id',
  `creator_id` varchar(255) DEFAULT NULL,
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `point_classify_id` bigint(20) DEFAULT NULL COMMENT '检查点扩展分类id',
  `basis_json` text COMMENT '标准依据',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=29446 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_task
-- ----------------------------
DROP TABLE IF EXISTS `p_task`;
CREATE TABLE `p_task` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `org_code` varchar(100) DEFAULT NULL COMMENT '公司id',
  `title` varchar(500) DEFAULT NULL COMMENT '任务标题',
  `publisher` varchar(255) DEFAULT NULL COMMENT '任务发布人id',
  `dep_id` varchar(255) DEFAULT NULL COMMENT '执行人部门',
  `publisher_name` varchar(40) DEFAULT NULL COMMENT '任务发布人名称',
  `publish_time` datetime DEFAULT NULL COMMENT '任务发布时间',
  `finish_time` datetime DEFAULT NULL COMMENT '任务应该完成时间',
  `fact_finish_time` datetime DEFAULT NULL COMMENT '任务实际完成时间',
  `is_warn` varchar(50) DEFAULT NULL COMMENT '是否告警通知（1 通知 ； 2 不通知 ）',
  `status` int(11) DEFAULT NULL COMMENT '任务状态',
  `warn_time` datetime DEFAULT NULL COMMENT '告警通知时间',
  `feedback_num` int(11) DEFAULT NULL COMMENT '回复个数',
  `executor` varchar(2000) DEFAULT NULL COMMENT '任务执行人',
  `depth` int(11) DEFAULT NULL COMMENT '当前任务发转次数',
  `max_depth` int(11) DEFAULT NULL COMMENT '任务最大转发次数',
  `remark` varchar(1000) DEFAULT NULL COMMENT '说明',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `config` longtext COMMENT '任务拍照配置',
  `executor_id` varchar(255) NOT NULL,
  `check_id` bigint(20) DEFAULT '0' COMMENT '任务关联检查项ID',
  `point_id` bigint(11) DEFAULT '0' COMMENT '任务关联巡检点id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `p_task_detail`;
CREATE TABLE `p_task_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) DEFAULT NULL COMMENT '任务id',
  `item_id` bigint(20) DEFAULT NULL COMMENT '检查项ID',
  `check_id` bigint(20) DEFAULT NULL COMMENT '检查记录id',
  `status` int(11) DEFAULT NULL COMMENT '任务相状态（1.完成，2.未完成，3.执行中）',
  `remark` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `point_id` bigint(20) DEFAULT NULL COMMENT '巡检点ID',
  `route_id` bigint(20) DEFAULT NULL COMMENT '路线ID',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_task_feedback
-- ----------------------------
DROP TABLE IF EXISTS `p_task_feedback`;
CREATE TABLE `p_task_feedback` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL COMMENT '组织编码',
  `task_id` bigint(20) NOT NULL COMMENT '任务ID',
  `user_id` varchar(255) NOT NULL COMMENT '任务回复人ID',
  `user_name` varchar(50) NOT NULL COMMENT '任务回复人名称',
  `feedback_time` datetime NOT NULL COMMENT '回复时间',
  `message` text COMMENT '任务回复信息',
  `picture_number` int(11) DEFAULT NULL COMMENT '拍照个数',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `message_type` varchar(20) DEFAULT NULL COMMENT '任务类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_task_forward_log
-- ----------------------------
DROP TABLE IF EXISTS `p_task_forward_log`;
CREATE TABLE `p_task_forward_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) DEFAULT NULL COMMENT '任务ID',
  `executor` varchar(255) DEFAULT NULL COMMENT '任务执行人',
  `executor_id` varchar(255) DEFAULT NULL,
  `created_by` bigint(20) DEFAULT NULL COMMENT '记录创建者',
  `content` varchar(2000) DEFAULT NULL COMMENT '任务转发记录详情',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for p_task_picture
-- ----------------------------
DROP TABLE IF EXISTS `p_task_picture`;
CREATE TABLE `p_task_picture` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL COMMENT '组织编码',
  `task_id` bigint(20) NOT NULL COMMENT '任务ID',
  `feedback_id` bigint(20) NOT NULL COMMENT '任务回复ID',
  `photo_data` longtext NOT NULL COMMENT '回复照片',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
SET FOREIGN_KEY_CHECKS=1;
