package com.yeejoin.amos.api.openapi.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class EquCategoryConverter implements Converter<String> {

    private static final Map<String, String> equipmentMap = new HashMap<>();

    static {
        // 填充映射关系
        equipmentMap.put("承压蒸汽锅炉", "1100");
        equipmentMap.put("承压热水锅炉", "1200");
        equipmentMap.put("有机热载体锅炉", "1300");
        equipmentMap.put("移动式压力容器", "2200");
        equipmentMap.put("气瓶", "2300");
        equipmentMap.put("氧舱", "2400");
        equipmentMap.put("桥式起重机", "4100");
        equipmentMap.put("门式起重机", "4200");
        equipmentMap.put("塔式起重机", "4300");
        equipmentMap.put("流动式起重机", "4400");
        equipmentMap.put("门座式起重机", "4700");
        equipmentMap.put("升降机", "4800");
        equipmentMap.put("缆索式起重机", "4900");
        equipmentMap.put("桅杆式起重机", "4A00");
        equipmentMap.put("机械式停车设备", "4D00");
        equipmentMap.put("机动工业车辆", "5100");
        equipmentMap.put("非公路用旅游观光车辆", "5200");
        equipmentMap.put("观览车类", "6100");
        equipmentMap.put("滑行车类", "6200");
        equipmentMap.put("固定式压力容器", "2100");
        equipmentMap.put("架空游览车类", "6300");
        equipmentMap.put("陀螺类", "6400");
        equipmentMap.put("飞行塔类", "6500");
        equipmentMap.put("转马类", "6600");
        equipmentMap.put("自控飞机类", "6700");
        equipmentMap.put("赛车类", "6800");
        equipmentMap.put("小火车类", "6900");
        equipmentMap.put("碰碰车类", "6A00");
        equipmentMap.put("滑道类", "6B00");
        equipmentMap.put("无动力游乐设施", "6E00");
        equipmentMap.put("工业管道", "8300");
        equipmentMap.put("客运架空索道", "9100");
        equipmentMap.put("客运缆车", "9200");
        equipmentMap.put("客运拖牵索道", "9300");
        equipmentMap.put("水上游乐设施类", "6D00");
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                    GlobalConfiguration globalConfiguration) {
        // 从Cell中读取数据
        String cellValue = cellData.getStringValue();
        // 判断Excel中的值，将其转换为预期的数值
        return equipmentMap.getOrDefault(cellValue, null);
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        // 实体类中对象属性类型
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new CellData("");
    }
}
