package com.yeejoin.amos.boot.module.tcm.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class EquipTypeConverter implements Converter<String> {
    private static final Map<String, String> CODE_MAP = new HashMap<>();

    static {
        CODE_MAP.put("锅炉", "1000");
        CODE_MAP.put("压力容器", "2000");
        CODE_MAP.put("电梯", "3000");
        CODE_MAP.put("起重机械", "4000");
        CODE_MAP.put("场（厂）内专用机动车辆", "5000");
        CODE_MAP.put("大型游乐设施", "6000");
        CODE_MAP.put("压力管道", "8000");
        CODE_MAP.put("客运索道", "9000");
    }

    @Override
    public Class supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String cellDataStr = cellData.getStringValue();
        return CODE_MAP.get(cellDataStr);
    }

    @Override
    public CellData convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }
}
