package com.yeejoin.amos.boot.module.tcm.api.dto;

import cn.afterturn.easypoi.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.yeejoin.amos.boot.module.tcm.api.converter.*;
import com.yeejoin.amos.boot.module.tcm.api.customer.CustomerEquipTypeCheck;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Data
public class UserImportDto {

    @NotBlank(message = "单位名称不能为空")
    @ExcelProperty(value = "单位名称")
    private String unitName;

    @NotBlank(message = "单位统一信用代码不能为空")
    @ExcelProperty(value = "单位统一信用代码")
    private String unitCode;

    @NotBlank(message = "单位类型不能为空")
    @ExcelProperty(value = "单位类型")
    private String unitType;

    @NotBlank(message = "姓名不能为空")
    @ExcelProperty(value = "姓名")
    private String name;

    @NotBlank(message = "联系电话不能为空")
    @ExcelProperty(value = "联系电话")
    private String phone;

    @NotBlank(message = "证件类型不能为空")
    @ExcelProperty(value = "证件类型", converter = CertificateTypeConverter.class)
    private String certificateType;


    @NotBlank(message = "证件编号不能为空")
    @ExcelProperty(value = "证件编号")
    private String certificateNum;

    @NotBlank(message = "人员类型不能为空")
    @ExcelProperty(value = "人员类型", converter = PostTypeConverter.class)
    private String post;


    @CustomerEquipTypeCheck(message = "设备类型不能为空")
    @ExcelProperty(value = "设备类型", converter = EquipTypeConverter.class)
    private String equipType;

    @ExcelProperty(value = "性别", converter = GenderConverter.class)
    private String gender;

    @ExcelProperty(value = "出生日期")
    @DateTimeFormat("yyyy-MM-dd")
    private Date birthday;

    @ExcelProperty(value = "学历", converter = EducationConverter.class)
    private String education;

    @ExcelProperty(value = "住址")
    private String address;

    @ExcelProperty(value = "邮箱")
    private String email;

    @ExcelProperty(value = "职称")
    private String jobTitle;

    @ExcelProperty(value = "专业")
    private String speciality;

    /**
     * 存放单位类型：List人员类型的对象
     */
    @ExcelIgnore
    private Map<String, Set<String>> unitTypePostMap;

    @ExcelProperty
    private Long seq;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserImportDto that = (UserImportDto) o;
        return Objects.equals(phone, that.phone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(phone);
    }
}
