package com.yeejoin.amos.patrol.business.util;

import com.yeejoin.amos.patrol.business.param.CatalogTreePageParam;
import com.yeejoin.amos.patrol.core.common.request.CommonPageable;
import com.yeejoin.amos.patrol.core.common.request.CommonRequest;

import java.util.HashMap;
import java.util.List;

public class CatalogTreePageParamUtil {

	public static  CatalogTreePageParam fillPageParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
		HashMap<String, Object> perMap) {	
		CatalogTreePageParam param = new CatalogTreePageParam();
		for(int i=0;i<queryRequests.size();i++){
			String name = queryRequests.get(i).getName();
			if("name".equals(name)){
				param.setName(toString(queryRequests.get(i).getValue()));
			}else if("parentId".equals(name)){
				param.setParentId(toString(queryRequests.get(i).getValue()));
			}
		}		

		param.setOrgCode(perMap.get("orgCode").toString());
		if(commonPageable !=null){
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());	
		}
		return param;
	}
	
	private static String toString(Object value) {
		if(null ==value || value ==""){
			return null;
		}else{
			return value.toString();
		}		
	}

}
