package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 管道工程装置表 Mapper 接口
 *
 * @author system_generator
 * @date 2024-12-11
 */
public interface IdxBizJgProjectContraptionMapper extends BaseMapper<IdxBizJgProjectContraption> {

    Map<String, Object> getDetail(@Param("sequenceNbr") String sequenceNbr);

    List<Map<String, Object>> selectEquipList(@Param("sequenceNbr") String sequenceNbr);

    /**
     * 统计工程装置的引用次数（非待提交、非已撤回、非已驳回）
     *
     * @param projectContraptionId 工程装置唯一标识
     * @return 被引用次数 > 0 则设备不可编辑
     */
    Integer countContraptionInUseTimesForEdit(@Param("projectContraptionId") Long projectContraptionId);

    /**
     * 统计设备被引用的次数（只有存在就算引用-作废除外）
     * @param projectContraptionId 设备唯一标识
     * @return 被引用次数 > 0 则设备不可删除
     */
    Integer countContraptionInUseTimesForDelete(@Param("projectContraptionId") Long projectContraptionId);
}
