package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.yeejoin.amos.boot.module.jxiop.api.dto.MapRegionDto;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.MapRegionServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.List;

import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 地图片区
 *
 * @author system_generator
 * @date 2023-06-08
 */
@RestController
@Api(tags = "地图片区Api")
@RequestMapping(value = "/map-region")
public class MapRegionController extends BaseController {

    @Autowired
    MapRegionServiceImpl mapRegionServiceImpl;

    /**
     * 新增地图片区
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增地图片区", notes = "新增地图片区")
    public ResponseModel<MapRegionDto> save(@RequestBody MapRegionDto model) {
        model = mapRegionServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新地图片区", notes = "根据sequenceNbr更新地图片区")
    public ResponseModel<MapRegionDto> updateBySequenceNbrMapRegion(@RequestBody MapRegionDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(mapRegionServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除地图片区", notes = "根据sequenceNbr删除地图片区")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(mapRegionServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个地图片区", notes = "根据sequenceNbr查询单个地图片区")
    public ResponseModel<MapRegionDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(mapRegionServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "地图片区分页查询", notes = "地图片区分页查询")
    public ResponseModel<Page<MapRegionDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<MapRegionDto> page = new Page<MapRegionDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(mapRegionServiceImpl.queryForMapRegionPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "地图片区列表全部数据查询", notes = "地图片区列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<MapRegionDto>> selectForList() {
        return ResponseHelper.buildResponse(mapRegionServiceImpl.queryForMapRegionList());
    }
}
