package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 设备报废注销
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_scrap_cancel")
public class JgScrapCancel extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 注销类型（1报废注销，2移装注销）
     */
    @TableField("cancel_type")
    private String cancelType;

    /**
     * 申请编号
     */
    @TableField("apply_no")
    private String applyNo;

    /**
     * 流程实例id
     */
    @TableField("instance_id")
    private String instanceId;

    /**
     * 办理状态
     */
    @TableField("audit_status")
    private String auditStatus;

    /**
     * 状态
     */
    @TableField("status")
    private String status;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 创建人ID
     */
    @TableField("create_user_id")
    private String createUserId;

    /**
     * 创建时间
     */
    @TableField("create_date")
    private Date createDate;

    /**
     * 流程状态
     */
    @TableField("instance_status")
    private String instanceStatus;

    /**
     * 下一执行节点ids
     */
    @TableField("next_execute_ids")
    private String nextExecuteIds;

    /**
     * 接收机构代码
     */
    @TableField("receive_org_code")
    private String receiveOrgCode;

    /**
     * 接收机构
     */
    @TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 接收机构公司代码
     */
    @TableField("receive_company_code")
    private String receiveCompanyCode;

    /**
     * 注销证明
     */
    @TableField("cancel_certificate")
    private String cancelCertificate;

    /**
     * 终审通过时间
     */
    @TableField("audit_pass_date")
    private Date auditPassDate;


    @TableField(value = "promoter")
    private String promoter;

    /**
     * 使用单位编码
     */
    @TableField("use_unit_code")
    private String useUnitCode;


    /**
     * 使用单位名称
     */
    @TableField(value = "use_unit_name")
    private String useUnitName;

    /**
     * 下一步任务ID
     */
    @TableField(value = "next_task_id")
    private String nextTaskId;

    /**
     * 设备监管码
     */
    @TableField("supervisory_code")
    private String supervisoryCode;

    /**
     * 下一节点可执行人
     */
    @TableField("next_execute_user_ids")
    private String nextExecuteUserIds;

}
