package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcBizManageModel;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcBizManageServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.BaseUnitLicence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

@RestController
@RequestMapping
@Api(tags = "检验检测业务管理")
@RequiredArgsConstructor
public class JyjcBizManageController extends BaseController {

    private final JyjcBizManageServiceImpl jyjcBizManageService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "检验检测机构开通业务列表，分页", notes = "检验检测机构开通业务列表，分页")
    public ResponseModel<IPage<?>> getManageList(@RequestParam(value = "current") int current,
                                                 @RequestParam(value = "size") int size,
                                                 @RequestBody JyjcBizManageModel model) {
        Page<JyjcBizManageModel> page = new Page<>(current, size);
        IPage<?> res = jyjcBizManageService.pageList(page, getSelectedOrgInfo().getCompany(), model);
        return ResponseHelper.buildResponse(res);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{appSeq}/area-enable")
    @ApiOperation(httpMethod = "PUT", value = "企业区域启用", notes = "企业区域启用")
    public ResponseModel<Boolean> enableBatch(@PathVariable String appSeq) {
        return ResponseHelper.buildResponse(jyjcBizManageService.enable(appSeq, getSelectedOrgInfo().getCompany()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{appSeq}/area-disable")
    @ApiOperation(httpMethod = "PUT", value = "企业区域停用", notes = "企业区域停用")
    public ResponseModel<Boolean> disableBatch(@PathVariable String appSeq) {
        return ResponseHelper.buildResponse(jyjcBizManageService.disable(appSeq, getSelectedOrgInfo().getCompany()));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/{appSeq}/licence-edit")
    @ApiOperation(httpMethod = "PUT", value = "资质停起用", notes = "资质停起用")
    public ResponseModel<Boolean> licenceEdit(@PathVariable String appSeq,
                                              @RequestBody List<BaseUnitLicence> licences) {
        return ResponseHelper.buildResponse(jyjcBizManageService.licenceEdit(appSeq, licences));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{appSeq}/licence-detail")
    @ApiOperation(httpMethod = "GET", value = "资质详情", notes = "资质详情")
    public ResponseModel<List<BaseUnitLicence>> licenceDetail(@PathVariable String appSeq) {
        return ResponseHelper.buildResponse(jyjcBizManageService.licenceDetail(appSeq));
    }


}
