package com.yeejoin.amos.api.householdapi.Utils;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.api.householdapi.face.model.HouseholdPvApiDto;
import com.yeejoin.amos.api.householdapi.face.model.HouseholdPvProducerInfoDto;
import com.yeejoin.amos.api.householdapi.face.orm.entity.HouseholdPvProducerInfo;
import com.yeejoin.amos.api.householdapi.face.service.impl.HouseholdPvApiServiceImpl;
import com.yeejoin.amos.api.householdapi.face.service.impl.HouseholdPvProducerInfoServiceImpl;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;

@Component
public class HouseholdPvUtils {
    @Autowired
    private  HouseholdPvProducerInfoServiceImpl householdPvProducerInfoServiceImpl;
    @Autowired
    private  HouseholdPvApiServiceImpl householdPvApiServiceImpl;


    public  HashMap<String, Object> getHeaderByProducerCode(String code) {
        HashMap<String, Object> hashMap = new HashMap<>();
        HashMap<String, String> hashMaphead = new HashMap<>();
        HouseholdPvProducerInfo householdPvProducerInfo =this.householdPvProducerInfoServiceImpl.queryForHouseholdPvProducerInfoByCode(code);
        String url = householdPvProducerInfo.getProdcerUrl() + householdPvProducerInfo.getTokenUrl();
        hashMap.put("apiurl", householdPvProducerInfo.getProdcerUrl());
        if (PVProducerInfoEnum.GDW.getCode().equals(code)) {
            HashMap<String, String> map = new HashMap<>();
            map.put("account", householdPvProducerInfo.getProdcerAccount());
            map.put("pwd", "Ljf5705@sems");
            String body = JSON.toJSONString(map);
            String response = HttpUtil.createPost(url).body(body).execute().body();
            JSONObject jsonObject = JSON.parseObject(response);
            if (jsonObject.get("data") != null) {
                JSONObject jsonObject1 = (JSONObject) jsonObject.get("data");
                hashMaphead.put("token", (String) jsonObject1.get("token"));
                hashMap.put("header", hashMaphead);
            }
        } else if (PVProducerInfoEnum.SH.getCode().equals(code)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("accountName", householdPvProducerInfo.getProdcerAccount());
            map.put("appId", householdPvProducerInfo.getProdcerAppid());
            map.put("appSecret", householdPvProducerInfo.getProdcerAppsecret());
            map.put("corporationId", householdPvProducerInfo.getCorporationId());
            map.put("accountType", 2);
            String body = JSON.toJSONString(map);
            String response = HttpUtil.createPost(url).body(body).execute().body();
            JSONObject jsonObject = JSON.parseObject(response);
            hashMaphead.put("Authorization", (String) jsonObject.get("data"));
            hashMap.put("header",hashMaphead);
        }
        return hashMap;
    }
    public   String gerResponseByAPiID(Long seq){
        HouseholdPvApiDto householdPvApiDto = this.householdPvApiServiceImpl.queryBySeq(seq);
        HashMap<String,Object> producerInfo  = this.getHeaderByProducerCode(householdPvApiDto.getProducerId());
        HashMap<String,String> headMap = (HashMap<String, String>) producerInfo.get("header");
        String respone="";
        if(householdPvApiDto.getRequestMethod().equals("POST")){
            respone = HttpUtil.createPost(producerInfo.get("apiurl")+householdPvApiDto.getApiUrl()).headerMap(headMap,true).
                    body(householdPvApiDto.getParamInfo()).execute().body();
        }
        if(householdPvApiDto.getRequestMethod().equals("GET")){
            respone = HttpUtil.createGet(producerInfo.get("apiurl")+householdPvApiDto.getApiUrl()).headerMap(headMap,true).
                    body(householdPvApiDto.getParamInfo()).execute().body();
        }
        return respone;
    }
}
