package com.yeejoin.amos.boot.module.jg.biz.feign;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

@FeignClient(name = "TZS-COMMON", path = "/tcm", configuration = {FeignConfiguration.class})
public interface TcmServiceFeignClient {

    /**
     * 人员信息列表分页查询
     */
    @RequestMapping(value = "/userInfo/page", method = RequestMethod.GET)
    ResponseModel<Page<Map<String, String>>> page(@RequestParam(value = "current") String current,
                                                  @RequestParam(value = "size") String size,
                                                  @RequestParam(value = "sort", required = false) String sort,
                                                  @RequestParam Map<String, Object> dto);

    @RequestMapping(value = "/userInfo/permission-page", method = RequestMethod.POST)
    ResponseModel<Page<Map<String, String>>> getUserByPermission(@RequestParam(value = "current") long current,
                                                                 @RequestParam(value = "size") long size,
                                                                 @RequestParam(value = "sort", required = false) String sort,
                                                                 @RequestParam(required = false, defaultValue = "all") String type,
                                                                 @RequestBody Map<String, Object> map);

}
