package com.yeejoin.amos.boot.module.ymt.flc.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.ymt.api.dto.WarningMsgDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.ESCylinderInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.MsgLog;
import com.yeejoin.amos.boot.module.ymt.api.enums.EarlyWarningLevelEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.ScheduleMapper;
import com.yeejoin.amos.boot.module.ymt.biz.dao.ESCylinderInfoRepository;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.MsgLogServiceImpl;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.StartPlatformTokenService;
import com.yeejoin.amos.boot.module.ymt.biz.service.impl.TzsAuthServiceImpl;
import com.yeejoin.amos.boot.module.ymt.flc.api.dto.*;
import com.yeejoin.amos.boot.module.ymt.flc.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.flc.api.mapper.CylinderInfoMapper;
import com.yeejoin.amos.boot.module.ymt.flc.api.service.ICylinderInfoService;
import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

/**
 * 气瓶基本信息服务实现类
 *
 * @author system_generator
 * @date 2021-12-14
 */
@Service
@Slf4j
public class CylinderInfoServiceImpl extends BaseService<CylinderInfoDto, CylinderInfo, CylinderInfoMapper>
        implements ICylinderInfoService {

    @Autowired
    CylinderUnitServiceImpl cylinderUnitServiceImpl;

    @Autowired
    CylinderUnitDataServiceImpl cylinderUnitDataServiceImpl;

    @Autowired
    CylinderInfoDataServiceImpl cylinderInfoDataServiceImpl;

    @Autowired
    CylinderTagsServiceImpl cylinderTagsServiceImpl;

    @Autowired
    CylinderFillingServiceImpl cylinderFillingServiceImpl;

    @Autowired
    CylinderIntegrityDataServiceImpl cylinderIntegrityDataServiceImpl;

    @Autowired
    CylinderFillingRecordServiceImpl cylinderFillingRecordServiceImpl;

    @Autowired
    CylinderFillingCheckServiceImpl cylinderFillingCheckServiceImpl;

    @Autowired
    CylinderAreaDataServiceImpl cylinderAreaDataServiceImpl;

    @Autowired
    CylinderFillingUnloadDataServiceImpl cylinderFillingUnloadDataServiceImpl;

    @Autowired
    CylinderInfoDataUnitServiceImpl cylinderInfoDataUnitServiceImpl;

    @Autowired
    CylinderFillingDataUnitServiceImpl cylinderFillingDataUnitServiceImpl;

    @Autowired
    CylinderTagsDataUnitServiceImpl cylinderTagsDataUnitServiceImpl;

    @Autowired
    CylinderIntegrityDataUnitServiceImpl cylinderIntegrityDataUnitServiceImpl;

    @Autowired
    CylinderFillingCheckDataUnitServiceImpl cylinderFillingCheckDataUnitServiceImpl;

    @Autowired
    CylinderFillingUnloadDataUnitServiceImpl cylinderFillingUnloadDataUnitServiceImpl;

    @Autowired
    MsgLogServiceImpl msgLogService;

    @Autowired
    private RuleTrigger ruleTrigger;

    @Autowired
    TzsAuthServiceImpl tzsAuthService;

    @Autowired
    private ScheduleMapper scheduleMapper;

    @Value("${cylinder-early-warning-packageId:气瓶监管/cylwarningmsg}")
    private String packageId;

    @Value("${cylinder-early-warning-packageId:气瓶消息预警/cylwarningmsg}")
    private String cylPackageId;

    @Autowired
    RestHighLevelClient restHighLevelClient;


    @Autowired
    StartPlatformTokenService startPlatformTokenService;

    @Autowired
    CylinderInfoMapper cylinderInfoMapper;

    @Autowired
    ESCylinderInfoRepository esCylinderInfoRepository;


    /**
     * 分页查询
     */
    public Page<CylinderInfoDto> queryForCylinderInfoPage(Page<CylinderInfoDto> page) {
        return queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<CylinderInfoDto> queryForCylinderInfoList() {
        return queryForList("", false);
    }

    @Override
    public Map<String, String> queryNumAndOutOfDateNum(Long unitId) {
        return baseMapper.queryNumAndOutOfDateNum(unitId);
    }

    /**
     * 获取上个月气瓶总量
     */
    public Integer getMonthInfoTotal(String regionCode) {
        return baseMapper.getMonthInfoTotal(regionCode);
    }

    /**
     * 获取上个月气瓶总量
     */
    public Integer getLastMonthInfoTotal(String regionCode) {
        return baseMapper.getLastMonthInfoTotal(regionCode);
    }

    /**
     * 获取上上个月气瓶总量
     */
    public Integer getMonthBeforeLastInfoTotal(String regionCode) {
        return baseMapper.getMonthBeforeLastInfoTotal(regionCode);
    }

    public Integer getInfoTotalByRegionCode(String regionCode) {
        return baseMapper.getInfoTotalByRegionCode(regionCode);
    }

    public Double queryIntegirtyByAppId(String appId) {
        return this.baseMapper.queryIntegirtyByAppId(appId);
    }

    public Integer getWarnNum(String code) {
        return baseMapper.getWarnNum(code);
    }

    /**
     * 按单位统计
     */
    @Transactional(rollbackFor = Exception.class)
    @Scheduled(cron = "0 0 2 * * ?")
    public void synFillingUnloadData() {
        cylinderFillingUnloadDataServiceImpl.remove(new LambdaQueryWrapper<CylinderFillingUnloadData>());
        countByRegion(regionModel -> {
            Calendar now = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < 30; i++) {
                now.add(Calendar.DATE, -1);
                CylinderFillingUnloadDataDto temp = new CylinderFillingUnloadDataDto();
                Double fillingSum = cylinderFillingRecordServiceImpl
                        .getFillingSum(String.valueOf(regionModel.getRegionCode()), now.getTime());
                Double unloadSum = 0d;
                temp.setFillingSum(fillingSum);
                temp.setRegionCode(String.valueOf(regionModel.getRegionCode()));
                temp.setStatisDate(now.getTime());
                temp.setStatisDateStr(sdf.format(now.getTime()));
                temp.setUnloadSum(unloadSum);
                cylinderFillingUnloadDataServiceImpl.createWithModel(temp);
            }
        });
    }

    /**
     * 按区域统计
     */
    @Transactional(rollbackFor = Exception.class)
    @Scheduled(cron = "0 0 2 * * ?")
    public void synAreaData() {
        cylinderAreaDataServiceImpl.remove(new LambdaQueryWrapper<CylinderAreaData>());
        countByRegion(regionModel -> {
            CylinderAreaDataDto temp = new CylinderAreaDataDto();
            temp.setAreaName(regionModel.getRegionName());
            String code = regionModel.getRegionCode() + "";
            Integer cylinderTotal = this.getInfoTotalByRegionCode(code);
            Integer cylinderUnitTotal = cylinderUnitServiceImpl.getUnitTotalByRegionCode(code);
            Integer cylinderUnitWarn = cylinderUnitServiceImpl.getWarnNum(code);
            Integer cylinderInfoWarn = this.getWarnNum(code);
            int warmTotal = cylinderUnitWarn + cylinderInfoWarn;
            String parentCode = "";
            if ("610000".equals(code)) {
                parentCode = "-1";
            } else if (!"00".equals(code.substring(4, 6))) {
                parentCode = code.substring(0, 4) + "00";
            } else {
                parentCode = "610000";
            }
            temp.setCylinderNum(Long.valueOf(cylinderTotal));
            temp.setParentRegionCode(parentCode);
            temp.setRegionCode(regionModel.getRegionCode() + "");
            temp.setUnitNum(Long.valueOf(cylinderUnitTotal));
            temp.setWarnNum((long) warmTotal);
            cylinderAreaDataServiceImpl.createWithModel(temp);
        });
    }

    /**
     * 按区域统计
     */
    @Transactional(rollbackFor = Exception.class)
    @Scheduled(cron = "0 0 2 * * ?")
    public void addIntegrityData() {
        System.out.println("====================数据完整性开始============================");
        cylinderIntegrityDataServiceImpl.remove(new LambdaQueryWrapper<CylinderIntegrityData>());
        countByRegion(regionModel -> {
            List<CylinderUnit> unitlist = cylinderUnitServiceImpl.list(new LambdaQueryWrapper<CylinderUnit>()
                    .like(CylinderUnit::getRegionCode, regionModel.getRegionCode()));
            List<CylinderIntegrityDataDto> tempList = new LinkedList<>();
            System.out.println(
                    "====================regioncode: " + regionModel.getRegionCode() + "============================");
            unitlist.forEach(t -> {
                System.out.println("====================appId: " + t.getAppId() + "============================");
                CylinderIntegrityDataDto temp = new CylinderIntegrityDataDto();
                String appId = t.getAppId();
                Double totalIntegirty = 0d;
                // tz_cylinder_info
                Double unitIntegirty = t.getIntegrity();
                unitIntegirty = unitIntegirty == null ? 0d : unitIntegirty;
                // tz_cylinder_tags
                Double tagIntegirty = cylinderTagsServiceImpl.queryIntegirtyByAppId(appId);
                tagIntegirty = tagIntegirty == null ? 0d : tagIntegirty;
                // tz_cylinder_info
                Double infoIntegirty = this.queryIntegirtyByAppId(appId);
                infoIntegirty = infoIntegirty == null ? 0d : infoIntegirty;
                // tz_cylinder_filling_record 30天内
                Double recordIntegirty = cylinderFillingRecordServiceImpl.queryIntegirtyByAppId(appId);
                recordIntegirty = recordIntegirty == null ? 0d : recordIntegirty;
                // tz_cylinder_filling 30天内ji
                Double fillingIntegirty = cylinderFillingServiceImpl.queryIntegirtyByAppId(appId);
                fillingIntegirty = fillingIntegirty == null ? 0d : fillingIntegirty;
                // tz_cylinder_filling_check 30天内
                Double checkIntegirty = cylinderFillingCheckServiceImpl.queryIntegirtyByAppId(appId);
                checkIntegirty = checkIntegirty == null ? 0d : checkIntegirty;
                totalIntegirty = (unitIntegirty + tagIntegirty + infoIntegirty + recordIntegirty + fillingIntegirty
                        + checkIntegirty) / 6;
                BigDecimal bg = new BigDecimal(totalIntegirty);
                totalIntegirty = bg.setScale(4, BigDecimal.ROUND_HALF_UP).doubleValue() * 100;
                temp.setAppId(appId);
                temp.setRegionCode(String.valueOf(regionModel.getRegionCode()));
                temp.setIntegrity(totalIntegirty);
                temp.setUnitName(t.getUnitName());
                // 判断list 是否达到5个，如果达到则对比最后一个进行替换
                if (tempList.size() == 5) {
                    if (tempList.get(0).getIntegrity() < totalIntegirty) {
                        tempList.set(0, temp);
                    }
                } else {
                    tempList.add(temp);
                }
                tempList.sort(Comparator.comparing(CylinderIntegrityDataDto::getIntegrity));
            });
            tempList.forEach(t -> {
                System.out.println("====================unitName: " + t.getUnitName() + "============================");
                t.setUpdateTime(new Date());
                cylinderIntegrityDataServiceImpl.createWithModel(t);
            });
        });
        System.out.println("====================数据完整性结束============================");
    }

    /**
     * 企业总量按区域统计
     */
    @Transactional(rollbackFor = Exception.class)
    @Scheduled(cron = "0 0 2 * * ?")
    public void getCylinderUnitInfo() {
        cylinderUnitDataServiceImpl.remove(new LambdaQueryWrapper<CylinderUnitData>());
        countByRegion(regionModel -> {
            String regionCode = String.valueOf(regionModel.getRegionCode());
            Integer cylinderUnitTotal = cylinderUnitServiceImpl.getUnitTotalByRegionCode(regionCode);
            Integer thisMonthUnitTotal = cylinderUnitServiceImpl.getThisMonthUnitTotalByRegionCode(regionCode);
            Double lastUnitTotal = Double.valueOf(cylinderUnitServiceImpl.getLastMonthUnitTotal(regionCode));
            Double monthUnitLastInfo = Double.valueOf(cylinderUnitServiceImpl.getMonthBeforeLastUnitTotal(regionCode));
            double changeNum = thisMonthUnitTotal - lastUnitTotal;
            double percent = 0d;
            if (monthUnitLastInfo != 0) {
                percent = (lastUnitTotal - monthUnitLastInfo) / monthUnitLastInfo;
                BigDecimal bg = new BigDecimal(percent);
                percent = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
            } else {
                percent = 0;
                BigDecimal bg = new BigDecimal(percent);
                percent = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
            }
            CylinderUnitDataDto temp = new CylinderUnitDataDto();
            temp.setChangeSum((long) changeNum);
            temp.setChangePercent((int) (percent * 100) + "");
            temp.setRegionCode(regionCode);
            temp.setTotalSum((long) cylinderUnitTotal);
            temp.setUpdateTime(new Date());
            cylinderUnitDataServiceImpl.createWithModel(temp);
        });
    }

    /**
     * 气瓶总量按区域统计
     */
    @Transactional(rollbackFor = Exception.class)
    @Scheduled(cron = "0 0 2 * * ?")
    public void getCylinderInfo() {
        cylinderInfoDataServiceImpl.remove(new LambdaQueryWrapper<>());
        countByRegion(regionModel -> {
            CylinderInfoDataDto temp = new CylinderInfoDataDto();
            String regionCode = String.valueOf(regionModel.getRegionCode());
            Integer cylinderTotal = this.getInfoTotalByRegionCode(regionCode);// 当前总数
            Double InfoTotal = Double.valueOf(this.getMonthInfoTotal(regionCode));
            Double lastInfoTotal = Double.valueOf(this.getLastMonthInfoTotal(regionCode));// 上月总数
            Double monthBeforeLastInfo = Double.valueOf(this.getMonthBeforeLastInfoTotal(regionCode));// 上上月总数
            double percent = 0d;
            if (monthBeforeLastInfo != 0) {
                percent = (lastInfoTotal - monthBeforeLastInfo) / monthBeforeLastInfo;
                BigDecimal bg = new BigDecimal(percent);
                percent = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
            } else {
                percent = 0;
                BigDecimal bg = new BigDecimal(percent);
                percent = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
            }
            temp.setChangeSum((long) (InfoTotal - lastInfoTotal));
            temp.setChangePercent((int) (percent * 100) + "");
            temp.setRegionCode(regionCode);
            temp.setTotalSum((long) cylinderTotal);
            cylinderInfoDataServiceImpl.createWithModel(temp);
        });
    }

    /**
     * 按单位统计
     */
    @Transactional(rollbackFor = Exception.class)
    @Scheduled(cron = "0 0 2 * * ?")
    public void synUnitCylinderInfoData() {
        cylinderInfoDataUnitServiceImpl.remove(new LambdaQueryWrapper<CylinderInfoDataUnit>());
        countByUnit(cylinderUnit -> {
            CylinderInfoDataUnitDto temp = new CylinderInfoDataUnitDto();
            temp.setAppId(cylinderUnit.getAppId());
            int count = this
                    .count(new LambdaQueryWrapper<CylinderInfo>().eq(CylinderInfo::getAppId, cylinderUnit.getAppId()));// 当前总数
            temp.setTotalSum((long) count);
            Double month = Double.valueOf(baseMapper.getMonthInfoTotalUnit(cylinderUnit.getAppId()));
            Double thismonth = Double.valueOf(baseMapper.getLastMonthInfoTotalUnit(cylinderUnit.getAppId()));// 上月总数
            Double lastmonth = Double.valueOf(baseMapper.getMonthBeforeLastInfoTotalUnit(cylinderUnit.getAppId()));// 上上月总数
            double percent = 0d;
            if (lastmonth != 0) {
                percent = (thismonth - lastmonth) / lastmonth;
                BigDecimal bg = new BigDecimal(percent);
                percent = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
            } else {
                percent = 0;
                BigDecimal bg = new BigDecimal(percent);
                percent = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
            }
            temp.setChangeSum((long) (month - thismonth));
            temp.setChangePercent((int) (percent * 100) + "");
            cylinderInfoDataUnitServiceImpl.createWithModel(temp);
        });
    }

    /**
     * 充装量按单位和月统计
     */
    @Transactional(rollbackFor = Exception.class)
    @Scheduled(cron = "0 0 2 * * ?")
    public void synUnitCylinderFillingData() {
        cylinderFillingDataUnitServiceImpl.remove(new LambdaQueryWrapper<CylinderFillingDataUnit>());
        countByUnit(cylinderUnit -> {
            // 按照月份 获取数据 取一年数据
            Calendar calendar = Calendar.getInstance();
            // 按月份获取充装量
            // 当月与上月 对比获取数据
            for (int i = 0; i < 12; i++) {
                // 获取当月数据
                CylinderFillingDataUnitDto temp = new CylinderFillingDataUnitDto();
                String year = calendar.get(Calendar.YEAR) + "";
                int month = calendar.get(Calendar.MONTH) + 1;
                String monthStr = month < 10 ? "0" + month : month + "";
                temp.setFillingYear(year);
                temp.setFillingMonth(monthStr);
                temp.setFillingDate(year + "-" + monthStr);
                // 本月
                Double thisMonth = cylinderFillingRecordServiceImpl.getFillingSumByMonth(cylinderUnit.getAppId(),
                        calendar.getTime());
                temp.setTotalSum(thisMonth);
                calendar.add(Calendar.MONTH, -1);
                // 上月
                Double lastMonth = cylinderFillingRecordServiceImpl.getFillingSumByMonth(cylinderUnit.getAppId(),
                        calendar.getTime());
                double percent = 0d;
                if (lastMonth != 0) {
                    percent = (thisMonth - lastMonth) / lastMonth;
                    BigDecimal bg = new BigDecimal(percent);
                    percent = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
                }
                temp.setChangePercent((int) (percent * 100) + "");
                temp.setAppId(cylinderUnit.getAppId());
                temp.setChangeSum(thisMonth - lastMonth);
                cylinderFillingDataUnitServiceImpl.createWithModel(temp);
            }
        });
    }

    /**
     * 按单位统计
     */
    @Transactional(rollbackFor = Exception.class)
    @Scheduled(cron = "0 0 2 * * ?")
    public void synUnitCylinderTagsData() {
        cylinderTagsDataUnitServiceImpl.remove(new LambdaQueryWrapper<CylinderTagsDataUnit>());
        countByUnit(cylinderUnit -> {
            CylinderTagsDataUnitDto temp = new CylinderTagsDataUnitDto();
            temp.setAppId(cylinderUnit.getAppId());
            int cylinder = this
                    .count(new LambdaQueryWrapper<CylinderInfo>().eq(CylinderInfo::getAppId, cylinderUnit.getAppId()));
            int tags = cylinderTagsServiceImpl
                    .count(new LambdaQueryWrapper<CylinderTags>().eq(CylinderTags::getAppId, cylinderUnit.getAppId()));
            String percent = "";
            if (tags != 0) {
                double zz = (double) cylinder / (double) tags;
                DecimalFormat df = new DecimalFormat("##.00%");
                if (Math.abs(zz) < 0.0000000000001) {
                    percent = "0.00%";
                } else {
                    percent = df.format(zz);
                }
            }
            temp.setCylinderSum((long) cylinder);
            temp.setTagsSum((long) tags);
            temp.setTagPercent(percent);
            cylinderTagsDataUnitServiceImpl.createWithModel(temp);
        });
    }

    /**
     * 按单位统计
     */
    @Transactional(rollbackFor = Exception.class)
    @Scheduled(cron = "0 0 2 * * ?")
    public void synUnitIntegrityData() {
        cylinderIntegrityDataUnitServiceImpl.remove(new LambdaQueryWrapper<CylinderIntegrityDataUnit>());
        countByUnit(cylinderUnit -> {
            // 企业信息
            CylinderIntegrityDataUnitDto uninInfo = new CylinderIntegrityDataUnitDto();
            uninInfo.setAppId(cylinderUnit.getAppId());
            uninInfo.setDataType("企业信息");
            Double unitIntegirty = cylinderUnit.getIntegrity();
            uninInfo.setIntegrity(unitIntegirty);
            cylinderIntegrityDataUnitServiceImpl.createWithModel(uninInfo);
            // 气瓶基本信息
            CylinderIntegrityDataUnitDto cylinderInfo = new CylinderIntegrityDataUnitDto();
            cylinderInfo.setAppId(cylinderUnit.getAppId());
            cylinderInfo.setDataType("气瓶基本信息");
            Double cylinderIntegirty = this.queryIntegirtyByAppId(cylinderUnit.getAppId());
            cylinderInfo.setIntegrity(cylinderIntegirty);
            cylinderIntegrityDataUnitServiceImpl.createWithModel(cylinderInfo);
            // 气瓶标签信息
            CylinderIntegrityDataUnitDto cylinderTag = new CylinderIntegrityDataUnitDto();
            cylinderTag.setAppId(cylinderUnit.getAppId());
            cylinderTag.setDataType("气瓶标签信息");
            Double tagIntegirty = cylinderTagsServiceImpl.queryIntegirtyByAppId(cylinderUnit.getAppId());
            cylinderTag.setIntegrity(tagIntegirty);
            cylinderIntegrityDataUnitServiceImpl.createWithModel(cylinderTag);
            // 气瓶检验信息
            CylinderIntegrityDataUnitDto cylinderInspection = new CylinderIntegrityDataUnitDto();
            cylinderInspection.setAppId(cylinderUnit.getAppId());
            cylinderInspection.setDataType("气瓶检验信息");
            cylinderInspection.setIntegrity(0d);
            cylinderIntegrityDataUnitServiceImpl.createWithModel(cylinderInspection);
            // 充装前检查
            CylinderIntegrityDataUnitDto cylinderFilling = new CylinderIntegrityDataUnitDto();
            cylinderFilling.setAppId(cylinderUnit.getAppId());
            cylinderFilling.setDataType("充装前检查");
            Double fillingIntegirty = cylinderFillingServiceImpl.queryIntegirtyByAppId(cylinderUnit.getAppId());
            cylinderFilling.setIntegrity(fillingIntegirty);
            cylinderIntegrityDataUnitServiceImpl.createWithModel(cylinderFilling);
            // 充装信息
            CylinderIntegrityDataUnitDto cylinderRecord = new CylinderIntegrityDataUnitDto();
            cylinderRecord.setAppId(cylinderUnit.getAppId());
            cylinderRecord.setDataType("充装信息");
            Double recordIntegirty = cylinderFillingRecordServiceImpl.queryIntegirtyByAppId(cylinderUnit.getAppId());
            cylinderRecord.setIntegrity(recordIntegirty);
            cylinderIntegrityDataUnitServiceImpl.createWithModel(cylinderRecord);
            // 充装后复查
            CylinderIntegrityDataUnitDto cylinderCheck = new CylinderIntegrityDataUnitDto();
            cylinderCheck.setAppId(cylinderUnit.getAppId());
            cylinderCheck.setDataType("充装后复查");
            Double checkIntegirty = cylinderFillingCheckServiceImpl.queryIntegirtyByAppId(cylinderUnit.getAppId());
            cylinderCheck.setIntegrity(checkIntegirty);
            cylinderIntegrityDataUnitServiceImpl.createWithModel(cylinderCheck);
        });
    }

    /**
     * 充装详情按单位统计
     */
    @Transactional(rollbackFor = Exception.class)
    @Scheduled(cron = "0 0 2 * * ?")
    public void synUnitFillingCheckData() {
//		cylinderFillingCheckDataUnitServiceImpl.remove(new LambdaQueryWrapper<CylinderFillingCheckDataUnit>());
        countByUnit(cylinderUnit -> {
            List<CylinderFillingCheckDataUnitDto> allCylinderFillingCheckDataList =
                    cylinderFillingCheckDataUnitServiceImpl.queryCylinderFillingCheckListByParam(cylinderUnit.getAppId(), null);
            // 按照月份 获取数据 取一年数据
            Calendar c = Calendar.getInstance();
            // 第一次查询到该appId对应的统计数据为空，则计算过去一年12个月的数据统计
            if (ValidationUtil.isEmpty(allCylinderFillingCheckDataList)) {
                // 按月份获取充装量
                // 当月与上月 对比获取数据
                for (int i = 0; i < 12; i++) {
                    // 获取当月数据
                    CylinderFillingCheckDataUnitDto temp = new CylinderFillingCheckDataUnitDto();
                    calcCylinderFillingCheckDataUnitData(cylinderUnit, c, temp);
                    c.add(Calendar.MONTH, -1);
                    cylinderFillingCheckDataUnitServiceImpl.createWithModel(temp);
                }
            } else {
                // 如果已经有该appId对应数据，则直接更新当前月的数据即可
                Calendar current = Calendar.getInstance();
                String year = current.get(Calendar.YEAR) + "";
                int month = current.get(Calendar.MONTH) + 1;
                String monthStr = month < 10 ? "0" + month : month + "";
                List<CylinderFillingCheckDataUnitDto> existDataDtoList =
                        cylinderFillingCheckDataUnitServiceImpl.queryCylinderFillingCheckListByParam(cylinderUnit.getAppId(), year + "-" + monthStr);
                CylinderFillingCheckDataUnitDto tempDto = new CylinderFillingCheckDataUnitDto();
                if (!ValidationUtil.isEmpty(existDataDtoList) && !ValidationUtil.isEmpty(existDataDtoList.get(0))) {
                    tempDto = existDataDtoList.get(0);
                    calcCylinderFillingCheckDataUnitData(cylinderUnit, current, tempDto);
                    cylinderFillingCheckDataUnitServiceImpl.updateWithModel(tempDto);
                } else if (ValidationUtil.isEmpty(existDataDtoList)) {
                    // 处理当前月第一天还没数据情况
                    calcCylinderFillingCheckDataUnitData(cylinderUnit, current, tempDto);
                    cylinderFillingCheckDataUnitServiceImpl.createWithModel(tempDto);
                }
            }
        });
    }

    /**
     * 计算当前单位的充装检查数据统计
     *
     * @param cylinderUnit
     * @param calender
     * @param cylinderFillingCheckDataUnitDto
     */
    public void calcCylinderFillingCheckDataUnitData(CylinderUnit cylinderUnit, Calendar calender, CylinderFillingCheckDataUnitDto cylinderFillingCheckDataUnitDto) {
        String year = calender.get(Calendar.YEAR) + "";
        int month = calender.get(Calendar.MONTH) + 1;
        String monthStr = month < 10 ? "0" + month : month + "";
        cylinderFillingCheckDataUnitDto.setFillingMonth(monthStr);
        cylinderFillingCheckDataUnitDto.setFillingYear(year);
        cylinderFillingCheckDataUnitDto.setFillingDate(year + "-" + monthStr);
        Integer countThisMonth = cylinderFillingRecordServiceImpl
                .getFillingCountByMonth(cylinderUnit.getAppId(), calender.getTime());
        cylinderFillingCheckDataUnitDto.setTotalSum((long) countThisMonth);
        // 获取本月数据
        Integer fillingCount = cylinderFillingServiceImpl.getFillingCountByMonth(cylinderUnit.getAppId(),
                calender.getTime());
        Integer fillingCheckCount = cylinderFillingCheckServiceImpl
                .getFillingCountByMonth(cylinderUnit.getAppId(), calender.getTime());
        // 充装前检查率：充装前检查次数/充装次数
        double before = 0d;
        if (countThisMonth != 0) {
            before = (double) (fillingCount) / (double) countThisMonth;
        }
        cylinderFillingCheckDataUnitDto.setFillingCount((long) fillingCount);
        cylinderFillingCheckDataUnitDto.setFillingPercent(before * 100);
        // 充装后检查率：充装后检查次数/充装次数
        double after = 0d;
        if (countThisMonth != 0) {
            after = (double) (fillingCheckCount) / (double) countThisMonth;
        }
        cylinderFillingCheckDataUnitDto.setFillingCheckCount((long) fillingCheckCount);
        cylinderFillingCheckDataUnitDto.setFillingCheckPercent(after * 100);
        // 充装合格率：充装前检查合格次数+充装后检查合格次数/2*充装次数
        double passed = 0d;
        // 充装前检查合格次数
        Integer fillingPassedCount = cylinderFillingServiceImpl
                .getFillingPassedCountByMonth(cylinderUnit.getAppId(), calender.getTime());
        // 充装后检查合格次数
        Integer fillingCheckPassedCount = cylinderFillingCheckServiceImpl
                .getFillingPassedCountByMonth(cylinderUnit.getAppId(), calender.getTime());
        if (countThisMonth != 0) {
            passed = ((double) (fillingPassedCount) + (double) fillingCheckPassedCount)
                    / (double) (2 * countThisMonth);
        }
        cylinderFillingCheckDataUnitDto.setFillingPassedCount((long) (fillingPassedCount + fillingCheckPassedCount));
        cylinderFillingCheckDataUnitDto.setTotalSumDouble((long) 2 * countThisMonth);
        cylinderFillingCheckDataUnitDto.setFillingPassedPercent(passed * 100);
        cylinderFillingCheckDataUnitDto.setAppId(cylinderUnit.getAppId());
    }

    /**
     * 充装量、卸液量按单位统计
     */
    @Transactional(rollbackFor = Exception.class)
    @Scheduled(cron = "0 0 2 * * ?")
    public void synFillingUnloadUnitData() {
        cylinderFillingUnloadDataUnitServiceImpl.remove(new LambdaQueryWrapper<CylinderFillingUnloadDataUnit>());
        countByUnit(cylinderUnit -> {
            Calendar now = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < 30; i++) {
                now.add(Calendar.DATE, -1);
                CylinderFillingUnloadDataUnitDto temp = new CylinderFillingUnloadDataUnitDto();
                Double fillingSum = cylinderFillingRecordServiceImpl.getFillingSumByDate(cylinderUnit.getAppId(),
                        now.getTime());
                Double unloadSum = 0d;
                temp.setFillingSum(fillingSum);
                temp.setAppId(cylinderUnit.getAppId());
                temp.setStatisDate(now.getTime());
                temp.setStatisDateStr(sdf.format(now.getTime()));
                temp.setUnloadSum(unloadSum);
                cylinderFillingUnloadDataUnitServiceImpl.createWithModel(temp);
            }
        });
    }

    @Scheduled(cron = "${tzs.cylinder.info.cron}")
    public void setTimeSaveCylinderInfoToES() {
        Page<CylinderInfoDto> cylinderInfoPage = new Page<>();
        Page<CylinderInfoDto> cyinderInfoList = cylinderInfoMapper.getCyinderInfoList(cylinderInfoPage);
        Long count = cyinderInfoList.getCurrent();
        Long times = 0L;
        if (count != 0) {
            times = count / 1000;
            Long last = count % 1000;
            if (last > 0) {
                times++;
            }
        }
        for (int i = 0; i <= times; i++) {
            cylinderInfoPage.setCurrent(1);
            cylinderInfoPage.setSize(1000);
            cylinderInfoPage = cylinderInfoMapper.getCyinderInfoList(cylinderInfoPage);
            if (!ObjectUtils.isEmpty(cylinderInfoPage)) {
                saveCylinderInfo2ES(cylinderInfoPage.getRecords());
            }
//			for (CylinderInfoDto ci : cylinderInfoPage.getRecords()) {
//				saveCylinderInfoToES(ci);
//			}
        }
    }

    @Override
    public void saveCylinderInfo2ES(List<CylinderInfoDto> records) {
        List<ESCylinderInfoDto> esCylinderInfoDto = new ArrayList<>();
        List<CylinderInfo> CylinderInfoList = new ArrayList<>();
        for (CylinderInfoDto record : records) {
            ESCylinderInfoDto esCylinderInfo = new ESCylinderInfoDto();
            BeanUtils.copyProperties(record, esCylinderInfo);
            esCylinderInfoDto.add(esCylinderInfo);
            CylinderInfo cylinderInfo = new CylinderInfo();
            BeanUtils.copyProperties(record, cylinderInfo);
            cylinderInfo.setSequenceNbr(record.getSequenceNbr());
            cylinderInfo.setIsNotEs("1");
            CylinderInfoList.add(cylinderInfo);
        }
        esCylinderInfoRepository.saveAll(esCylinderInfoDto);
        this.updateBatchById(CylinderInfoList);
    }

    @Override
    public Integer getInfoTotal() {
        return cylinderInfoMapper.getInfoTotal();
    }

    @Override
    public ESCylinderInfoDto saveCylinderInfoToES(CylinderInfoDto ci) {
        ESCylinderInfoDto esCylinderInfoDto = new ESCylinderInfoDto();
        BeanUtils.copyProperties(ci, esCylinderInfoDto);
        ESCylinderInfoDto saveResult = esCylinderInfoRepository.save(esCylinderInfoDto);
        if (!ObjectUtils.isEmpty(saveResult)) {
            //同步到es后修改
            CylinderInfo cylinderInfo = new CylinderInfo();
            cylinderInfo.setIsNotEs("1");
            cylinderInfoMapper.update(cylinderInfo, new QueryWrapper<CylinderInfo>().eq("sequence_nbr", ci.getSequenceNbr()));
        }
        return saveResult;
    }


    @Override
    public Page<ESCylinderInfoDto> queryByKeys(CylinderInfoDto cylinderInfoDto, int pageNum, int pageSize) {

        Page<ESCylinderInfoDto> result = new Page<ESCylinderInfoDto>(pageNum, pageSize);
        SearchRequest request = new SearchRequest();
        request.indices("cylinder_info");

        //通用匹配规则，条件构建
        boolean flag = true;

        SearchSourceBuilder builder = new SearchSourceBuilder();
        BoolQueryBuilder boolMust = QueryBuilders.boolQuery();

        //匹配统一信用代码
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getCreditCode())) {
            flag = false;
            BoolQueryBuilder meBuilder = QueryBuilders.boolQuery();
            meBuilder.must(QueryBuilders.matchQuery("creditCode", cylinderInfoDto.getCreditCode()));
            boolMust.must(meBuilder);
        }

        //匹配RegionCode
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getRegionCode())) {
            flag = false;
            BoolQueryBuilder appIdBuilder = QueryBuilders.boolQuery();
            appIdBuilder.must(QueryBuilders.matchQuery("regionCode", "*" + cylinderInfoDto.getRegionCode() + "*"));
            boolMust.should(appIdBuilder);
        }

        //匹配appid
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getAppId())) {
            flag = false;
            BoolQueryBuilder appIdBuilder = QueryBuilders.boolQuery();
            appIdBuilder.must(QueryBuilders.matchQuery("appId", "*" + cylinderInfoDto.getAppId() + "*"));
            boolMust.should(appIdBuilder);
        }

        //匹配产权单位
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getUnitName())) {
            flag = false;
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.matchQuery("unitName", "*" + cylinderInfoDto.getUnitName() + "*"));
            boolMust.must(query);
        }

        //匹配出厂编号
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getFactoryNum())) {
            flag = false;
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.matchQuery("factoryNum", "*" + cylinderInfoDto.getFactoryNum() + "*"));
            boolMust.must(query);
        }

        //匹配气瓶品种
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getCylinderVariety())) {
            flag = false;
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.matchQuery("cylinderVariety", cylinderInfoDto.getCylinderVariety()));
            boolMust.must(query);
        }

        //匹配二维码编码
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getQrCode())) {
            flag = false;
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.matchQuery("qrCode", "*" + cylinderInfoDto.getQrCode() + "*"));
            boolMust.must(query);
        }

        //匹配电子标签
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getElectronicLabelCode())) {
            flag = false;
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.matchQuery("electronicLabelCode", "*" + cylinderInfoDto.getElectronicLabelCode() + "*"));
            boolMust.must(query);
        }

        //匹配气瓶唯一标识
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getSequenceCode())) {
            flag = false;
            BoolQueryBuilder sequenceCodeBuilder = QueryBuilders.boolQuery();
            sequenceCodeBuilder.must(QueryBuilders.matchQuery("sequenceCode", cylinderInfoDto.getSequenceCode()));
            boolMust.must(sequenceCodeBuilder);
        }

        //匹配单位内部编号
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getUnitInnerCode())) {
            flag = false;
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.matchQuery("unitInnerCode", "*" + cylinderInfoDto.getUnitInnerCode() + "*"));
            boolMust.must(query);
        }

        //气瓶状态
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getCylinderStatus())) {
            flag = false;
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.matchQuery("cylinderStatus", cylinderInfoDto.getCylinderStatus()));
            boolMust.must(query);
        }

        //制造单位
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getManufacturingUnit())) {
            flag = false;
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.matchQuery("manufacturingUnit", "*" + cylinderInfoDto.getManufacturingUnit() + "*"));
            boolMust.must(query);
        }

        //检验日期
        if (!ObjectUtils.isEmpty(cylinderInfoDto.getInspectionDateStart()) && !ObjectUtils.isEmpty(cylinderInfoDto.getInspectionDateEnd())) {
            flag = false;
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query.must(QueryBuilders.rangeQuery("inspectionDate").from(cylinderInfoDto.getInspectionDateStart()).to(cylinderInfoDto.getInspectionDateEnd()));
            boolMust.must(query);
        }

        if (flag) { // 搜索全部
            boolMust.must(QueryBuilders.matchAllQuery());
        }

        builder.query(boolMust);
        builder.from((pageNum - 1) * pageSize);
        builder.size(pageSize);
        builder.trackTotalHits(true);
        request.source(builder);
        List<ESCylinderInfoDto> list = new LinkedList<>();
        long totle = 0;
        try {
            SearchResponse response = restHighLevelClient.search(request, RequestOptions.DEFAULT);
            for (org.elasticsearch.search.SearchHit hit : response.getHits()) {
                JSONObject jsonObject = (JSONObject) JSONObject.toJSON(hit);
                ESCylinderInfoDto esCylinderInfoDto = JSONObject.toJavaObject(jsonObject.getJSONObject("sourceAsMap"), ESCylinderInfoDto.class);
                list.add(esCylinderInfoDto);
            }
            totle = response.getInternalResponse().hits().getTotalHits().value;
            result.setRecords(list);
            result.setTotal(totle);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        return result;
    }


    /**
     * 根据月份统计
     */
    private void countByMonth(IntConsumer consumer) {
        for (int i = 0; i < 12; i++) {
            consumer.accept(i);
        }
    }

    /**
     * 根据单位统计
     */
    private void countByUnit(Consumer<CylinderUnit> consumer) {
        List<CylinderUnit> units = cylinderUnitServiceImpl.list();
        units.forEach(consumer);
    }

    /**
     * 根据区域统计
     */
    private void countByRegion(Consumer<RegionModel> consumer) {
        List<RegionModel> regionList = new ArrayList<>();
        startPlatformTokenService.getToken();
        Collection<RegionModel> regions = Systemctl.regionClient.queryForTree(null).getResult();
        regions.forEach(regionModel -> convertTreeToList(regionList, regionModel));
        regionList.forEach(consumer);
    }

    /**
     * 将区域树转为区域List列表
     */
    private void convertTreeToList(List<RegionModel> regionList, RegionModel region) {
        regionList.add(region);
        if (region.getChildren() != null) {
            region.getChildren().forEach(c -> {
                convertTreeToList(regionList, c);
            });
        }
    }

    public Integer getOverDateStatisticsNumber(String earlyWarningLevel) {
        return this.baseMapper.countOverDateNumber(earlyWarningLevel);
    }

    public Page<CylinderInfoDto> earlyWarningLevelPageList(Page<CylinderInfoDto> page, String earlyWarningLevel) {
        Page<CylinderInfoDto> result = this.baseMapper.queryPageListByEarlyWarningLevel(page, earlyWarningLevel);
        result.getRecords().forEach(r -> {
//            r.setEarlyWarningLevelName(EarlyWarningLevelEnum.getEumByLevel(earlyWarningLevel).getName());
//            r.setInspectionStatusDesc(EarlyWarningLevelEnum.getEumByLevel(earlyWarningLevel).getStatus());
        });

        return result;
    }

    public void calEarlyWarningLevel() {
        if (log.isDebugEnabled()) {
            log.debug("气瓶超期预警时间调用规则开始");
        }
        // 1.批量分组大小
        int size = 500;
        int total = this.count();
        int groupNumber = total / size + 1;
        // 2.批量小分组处理数据，调用规则
        for (int i = 0; i < groupNumber; i++) {
            Page<CylinderInfo> page = new Page<>();
            page.setCurrent(i);
            page.setSize(size);
            LambdaQueryWrapper<CylinderInfo> wrapper = new LambdaQueryWrapper<>();
            wrapper.select(CylinderInfo::getSequenceCode, CylinderInfo::getSequenceNbr)
                    .orderByDesc(CylinderInfo::getSequenceNbr);
            IPage<CylinderInfo> result = this.page(page, wrapper);
            for (CylinderInfo r : result.getRecords()) {
                // 设置token
                tzsAuthService.setRequestContext();
                // 调用规则
                this.touchRuleToCalLevel(r);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("气瓶超期预警时间调用规则完成");
        }
    }

    private void touchRuleToCalLevel(CylinderInfo r) {
        Date now = new Date();
        String dateStr;
        try {
            dateStr = DateUtils.dateFormat(now, DateUtils.DATE_TIME_PATTERN);
        } catch (ParseException e) {
            throw new RuntimeException("日期个时候失败");
        }
        // 1.气瓶详情
        CylinderInfoDto cylinderInfoDto = this.getDetail(r.getSequenceCode());
        try {
            WarningMsgDto warningMsgDto = new WarningMsgDto();
            int interval = DateUtils.dateBetweenIncludeToday(now, cylinderInfoDto.getNextInspectionDate()) - 1;
            warningMsgDto.setNum(String.valueOf(interval));
            warningMsgDto.setFactoryNum(cylinderInfoDto.getFactoryNum());
//            warningMsgDto.setUserType(cylinderInfoDto.getCustomType());
//            warningMsgDto.setUserPeople(cylinderInfoDto.getCustomName());
//            warningMsgDto.setUserPeoplePhone(cylinderInfoDto.getContactPhone());
            warningMsgDto.setCode(cylinderInfoDto.getSequenceCode());
            warningMsgDto.setCompanyName(cylinderInfoDto.getUnitName());
            warningMsgDto.setPhone(cylinderInfoDto.getPersonMobilePhone());
            warningMsgDto.setPeople(cylinderInfoDto.getUnitPerson());
            warningMsgDto.setCurrentTime(dateStr);
            // 2.循环调用规则 触发计算等级及发送消息
            if (log.isInfoEnabled()) {
                log.info("调用规则对象！+：{}", JSON.toJSONString(warningMsgDto));
            }
            ruleTrigger.publish(warningMsgDto, packageId, null);
        } catch (Exception e) {
            log.error("调用规则失败！:{},{}", JSON.toJSONString(cylinderInfoDto), e);
        }
    }

    public CylinderInfoDto getDetail(String sequenceCode) {
        CylinderInfoDto dto = scheduleMapper.getCylDetail(sequenceCode);
        dto.setInspectionStatusDesc(StringUtils.isNotEmpty(dto.getEarlyWarningLevel())
                ? EarlyWarningLevelEnum.getEumByLevel(dto.getEarlyWarningLevel()).getStatus()
                : "");
        return dto;
    }

    public List<MsgLog> getMsgList(String sequenceCode, String terminalType) {
        LambdaQueryWrapper<MsgLog> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(MsgLog::getRelationCode, sequenceCode);
        wrapper.eq(StringUtils.isNotEmpty(terminalType), MsgLog::getTerminalType, terminalType);
        wrapper.orderByDesc(MsgLog::getSendTime);
        return msgLogService.list(wrapper);
    }

    /**
     * 更新气瓶等级
     *
     * @param sequenceCode 唯一表设
     * @param level        等级
     * @return CylinderInfo
     */
    public CylinderInfo updateEarlyWarningLevel(String sequenceCode, String level) {
        CylinderInfo cylinderInfo = this
                .getOne(new LambdaQueryWrapper<CylinderInfo>().eq(CylinderInfo::getSequenceCode, sequenceCode));
        cylinderInfo.setEarlyWarningLevel(level);
        cylinderInfo.setEarlyWarningLevelCalDate(new Date());
        this.updateById(cylinderInfo);
        return cylinderInfo;
    }

    public Boolean nextInspectionDateUpdate(List<CylinderInfoDto> cylinderInfoDtos) {
        // 1.更新下次检验日期
        List<CylinderInfo> cylinderInfos = new ArrayList<>();
        cylinderInfoDtos.forEach(c -> {
            CylinderInfo cylinderInfo = this.getOne(
                    new LambdaQueryWrapper<CylinderInfo>().eq(CylinderInfo::getSequenceCode, c.getSequenceCode()));
//            cylinderInfo.setNextInspectionDate(c.getNextInspectionDate());
            cylinderInfos.add(cylinderInfo);
        });
        if (!cylinderInfos.isEmpty()) {
            this.updateBatchById(cylinderInfos);
        }
        // 2.循环调用规则 触发计算等级及发送消息
        cylinderInfos.forEach(this::touchRuleToCalLevel);
        return Boolean.TRUE;
    }

    public Page<CylinderInfoDto> cyinderInfoList(Page<CylinderInfoDto> page, CylinderInfoDto cylinderInfoDto, String sort, List<String> appids) {
        return cylinderInfoMapper.cyinderInfoList(page, cylinderInfoDto, sort, appids);
    }


    public Page<CylinderInfoDto> getCyinderInfoList(Page<CylinderInfoDto> page) {
        return cylinderInfoMapper.getCyinderInfoList(page);
    }

    public Page<CylinderInfoDto> cyinderOutInfoList(Page<CylinderInfoDto> page, CylinderInfoDto cylinderInfoDto, String sort, List<String> appids) {
        return cylinderInfoMapper.cyinderOutInfoList(page, cylinderInfoDto, sort, appids);
    }
}