package com.yeejoin.amos.api.openapi.face.model;

import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;


@EqualsAndHashCode(callSuper = true)
@Data
public class CylinderFillingModel extends AbstractBaseModel{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String fillingBeforeId;	//	充装前检查Id*
	private String fillingUnitName;	//充装企业名称*
	private String factoryNum;	//出厂编号
	private String sequenceCode;	//气瓶唯一标识码*
	private String isValid;	//是否在检验有效期以内，严禁充装超期未检气瓶、非法改装或翻新及报废气瓶
	private int same;	//警示标签上印有的瓶装气体的名称及化学分子式应与气瓶钢印标志是否一致*
	private int isRegulations;	//气瓶外表面的颜色标志是否符合规定*
	private int isComplianceWithGBT;	//气瓶瓶阀的出气口螺纹型式是否符合GB/T15383的规定，即可燃气体用的瓶阀，出口螺纹应是内螺纹（左旋）*
	private int haveStillPressure;	//气瓶内有无剩余压力*
	private int isComplete;	//气瓶外表面有无裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷*
	private int haveSecurityDocuments;	//气瓶的安全附件齐全并符合安全要求
	private String inspectorUser;	//检查人员姓名*
	private String inspectionDate;	//检查时间*

}
