package com.yeejoin.equipmanage.common.entity.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.common.entity.dto
 * @ClassName: EquipmentSpecificSerivceAlarmDTO
 * @Author: Jianqiang Gao
 * @Description: EquipmentSpecificSerivceAlarmDTO
 * @Date: 2020/12/24 10:41
 * @Version: 1.0
 */
@Data
public class EquipSpecificAlarmDTO {

    private Long id;

    @ApiModelProperty(value = "装备id")
    private Long equipmentSpecificId;

    @ApiModelProperty(value = "设备具体编码")
    private String fireEquipmentCode;

    @ApiModelProperty(value = "设备具体名称")
    private String fireEquipmentName;

    @ApiModelProperty(value = "设备具体位置")
    private String warehouseStructureName;

    @ApiModelProperty(value = "告警类型名称")
    private String fireEquipmentSpecificIndexName;

    @ApiModelProperty(value = "设备具体告警日期")
    private String createDate;

    @ApiModelProperty(value = "报警状态: 1报警0恢复")
    private int status;

    @ApiModelProperty(value = "告警信息id")
    private Long equipmentSpecificAlarmId;

    @ApiModelProperty(value = "报警类型")
    private String type;

    @ApiModelProperty(value = "确认类型")
    private String confirmType;

    @ApiModelProperty(value = "是否确警,yes-已确认，no-未确认")
    private String isFirm;

    @ApiModelProperty(value = "确警人")
    private String confirmUserName;

    @ApiModelProperty(value = "确警日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date confirmDate;

    @ApiModelProperty(value = "报警原因")
    private String alarmReason;

    @ApiModelProperty(value = "处理情况")
    private String resolveResult;

    @ApiModelProperty(value = "装备编号")
    private String code;

    @ApiModelProperty(value = "日志第一行")
    private String row1;

    @ApiModelProperty(value = "日志第二行")
    private String row2;

    @ApiModelProperty(value = "日志第三行")
    private String row3;

    @ApiModelProperty(value = "时间轴")
    private String dateAxis;

}