package com.yeejoin.equipmanage.service;

import com.yeejoin.equipmanage.common.entity.DynamicFormGroup;

/**
 * @author DELL
 */
public interface IDynamicFormService {
    /**
     * 生成下一个id 和编号
     * @return
     */
    Object nextIdCode();

    /**
     * 分组及分组下字段查询
     * @param groupId 分组id
     * @return Object
     */
    DynamicFormGroup getGroupsAndColumns(Long groupId);

    /**
     * 动态表单保存
     * @param dynamicFormGroup 数据
     * @param orgCode 组织机构
     * @return DynamicFormGroup
     */
    DynamicFormGroup saveGroupAndColumn(DynamicFormGroup dynamicFormGroup, String orgCode);

    /**
     * 查询 指定分组的分组
     * @param instanceId 实例id
     * @param groupId 分组id(消防系统id)
     * @return Object
     */
    Object getInstanceDetail(String instanceId, Long groupId);
}
