package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jcs.api.entity.AirportStand;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.AirportStandServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jcs.api.dto.AirportStandDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 机场机位旋转角度
 *
 * @author litw
 * @date 2021-09-17
 */
@RestController
@Api(tags = "机场机位旋转角度Api")
@RequestMapping(value = "/airport-stand")
public class AirportStandController extends BaseController {

    @Autowired
    AirportStandServiceImpl airportStandServiceImpl;

    /**
     * 根据sequenceNbr查询
     *
	 * @param standCode  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{standCode}")
	@ApiOperation(httpMethod = "GET",value = "根据standCode查询单个机场机位旋转角度",  notes = "根据standCode查询单个机场机位旋转角度")
	public ResponseModel<AirportStandDto> selectOne(@PathVariable String standCode) {
		QueryWrapper<AirportStand> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("stand_code",standCode);
		AirportStand airportStand = airportStandServiceImpl.getOne(queryWrapper);
		AirportStandDto airportStandDto = new AirportStandDto();
		BeanUtils.copyProperties(airportStand,airportStandDto);
	    return ResponseHelper.buildResponse(airportStandDto);
	}
}
