package com.yeejoin.amos.api.openapi.face.service;


import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderFillingCheckModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderFillingCheckMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderFillingCheck;
import com.yeejoin.amos.api.openapi.service.MyBaseServiceImpl;
import com.yeejoin.amos.api.openapi.util.MultiFieldKey;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.Bean;

import java.util.Date;
import java.util.List;


/**
 * 
 * <pre>
 * 气瓶充装信息-充装后复查 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class TmCylinderFillingCheckService extends MyBaseServiceImpl<TmCylinderFillingCheckModel, TmCylinderFillingCheck, TmCylinderFillingCheckMapper> {

	@Autowired
	private SyncCylinderDataService syncCylinderDataService;

	@Autowired
	private SnowflakeIdUtil sequence;

	@DSTransactional
	public void createCylinderFillingAfter(List<TmCylinderFillingCheckModel> model) {
		String appId = getAppId();
		Date now = new Date();
		for (TmCylinderFillingCheckModel cylinderFillingCheckModel : model) {
			cylinderFillingCheckModel.setSequenceNbr(sequence.nextId());
			cylinderFillingCheckModel.setRecDate(now);
			cylinderFillingCheckModel.setAppId(appId);
		}
		// 同步至气瓶业务库
		syncCylinderFillingAfter(model);

		List<TmCylinderFillingCheck> tmCylinderFillingCheckList = Bean.toModels(model, TmCylinderFillingCheck.class);
		saveOrUpdateBatchByUniqueFields(
				tmCylinderFillingCheckList,
				tmCylinderFillingCheck -> new LambdaQueryWrapper<TmCylinderFillingCheck>()
						.eq(TmCylinderFillingCheck::getAppId, tmCylinderFillingCheck.getAppId())
						.eq(TmCylinderFillingCheck::getSequenceCode, tmCylinderFillingCheck.getSequenceCode())
						.eq(TmCylinderFillingCheck::getFillingBeforeId, tmCylinderFillingCheck.getFillingBeforeId()),
				entity -> new MultiFieldKey(entity.getAppId(), entity.getSequenceCode(), entity.getFillingBeforeId()),
				"appId",
				"sequenceCode",
				"fillBeforeId");
	}

	private void syncCylinderFillingAfter(List<TmCylinderFillingCheckModel> model) {
		syncCylinderDataService.syncCylinderFillingAfter(model);
	}
}
