package com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.module.jg.api.annotation.DictCode2DictName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 企业信息
 */
@Data
public class BaseEnterpriseVo {

    @ExcelProperty(value = "单位类型")
    String unitType;

    @ExcelProperty(value = "单位统一信用代码")
    String useCode;
    
    @ExcelProperty(value = "单位名称")
    String useUnit;

    @ExcelProperty(value = "企业标签信息")
    private String regulatoryLabels;

    @ExcelProperty(value = "监管系统唯一编码")
    String superviseCode;

    @ExcelProperty(value = "使用单位证件类型")
    String useUnitCertificate;

    @ExcelProperty(value = "监管机构组织机构代码")
    String superviseOrgCode;

    @ExcelProperty(value = "监管机构名称")
    String superviseOrgName;

    @ExcelProperty(value = "单位所在省份名称")
    String province;

    @ExcelProperty(value = "单位所在城市名称")
    String city;

    @ExcelProperty(value = "单位所在区县名称")
    String district;

    @ExcelProperty(value = "单位所在街道名称")
    String street;

    @ExcelProperty(value = "单位所在社区名称")
    String community;

    @ExcelProperty(value = "单位详细地址")
    String address;

    @ExcelProperty(value = "使用单位法人")
    String legalPerson;

    @ExcelProperty(value = "法人联系电话")
    String legalPhone;

    @ExcelProperty(value = "使用单位联系人")
    String useContact;

    @ExcelProperty(value = "联系人联系电话")
    String contactPhone;
    
    @ExcelProperty(value = "管辖机构")
    String governingBody;
    

    @ExcelProperty(value = "所属行业")
    String industry;

    @ExcelProperty(value = "登记机关")
    String registrationAuthority;

    @ExcelProperty(value = "核准时间")
    Date approvalTime;

    @ExcelProperty(value = "经营状态")
    String operatingStatus;

    @ExcelProperty(value = "涉及设备类型")
    String equipCategory;


    @ExcelProperty(value = "行业主管部门")
    @DictCode2DictName(type = "HYZGBM", typeHandler = "cbDataDictTypeHandler")
    String industrySupervisor;

    @ExcelProperty(value = "注册类型")
    String registerType;
    
    @ExcelProperty("证书类型")
    String certType;

    @ExcelProperty("证书编号(核准证编号)")
    String certNo;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ExcelProperty("有效期至")
    Date expiryDate;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ExcelProperty("发证日期")
    Date issueDate;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ExcelProperty("变更日期")
    Date changeDate;

    @ExcelProperty("许可方式/许可状态")
    String applyType;

    @ExcelProperty("备注")
    String remark;
    
    @ExcelProperty("许可项目/检验类型/设备品种（核准项目名称）")
    String itemCodeName;
    
    @ExcelProperty("许可子项目/检验项目/充装介质类别")
    String subItemName;
    
    @ExcelProperty("许可参数/充装介质名称")
    String parameter;
    
    @ExcelProperty("固定检验地址")
    String itemAddress;
    
    @ExcelProperty("发证机关")
    String approvedOrgan;
    
}
