package com.yeejoin.amos.boot.module.statistics.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface JGStatisticsMapper {

    List<Map<String, Object>> maintenanceCountTopTen(@Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto, @Param("regionCodeList") List<Integer> regionCodeList);

    List<Map<String, Object>> maintenanceCount(@Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto, @Param("regionCodeList") List<Integer> regionCodeList);

    List<Map<String, Object>> installEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> maintenanceEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> reformEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> transferEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);


    List<Map<String, Object>> useEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> changeReformEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> changeTransferEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> changeUnitEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> vehicleEquCount(@Param("cityCode") String cityCode, @Param("startTime") String startTime);

    List<Map<String, Object>> newRegEquCountByMonth(@Param("cityCode") String cityCode);

    List<Map<String, Object>> newVehicleEquCountByMonth(@Param("cityCode") String cityCode);

    List<Map<String, Object>> newRegEquCountByYear(@Param("cityCode") String cityCode);
    List<Map<String, Object>> newRegEquCountByLastYear(@Param("cityCode") String cityCode);

    List<Map<String, Object>> newVehicleEquCountByYear(@Param("cityCode") String cityCode);
    List<Map<String, Object>> newVehicleEquCountByLastYear(@Param("cityCode") String cityCode);

    String newVehicleCountByYear(@Param("cityCode") String cityCode);

    String newVehicleCountByMonth(@Param("cityCode") String cityCode);

    long certificateCountByOrgCode(@Param("orgCode") String orgCode);

    long useCountByOrgCode(@Param("orgCode") String orgCode);

    Long over15yearsCount(@Param("orgCode") String orgCode, @Param("time") String time);

    Long constructionNoticeCount(@Param("orgCode") String orgCode);

    Long changeCountByOrgCode(@Param("orgCode") String orgCode);

    List<Map<String, Object>> selectNoticeList(@Param("orgCode") String orgCode, @Param("time") String time);

    Page<Map<String, Object>> selectNoticeDetailList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamForDetailDto dpFilterParamDto);

    Page<Map<String, Object>> selectAZNoticeDetailList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamForDetailDto dpFilterParamDto);

    Page<Map<String, Object>> selectWXNoticeDetailList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamForDetailDto dpFilterParamDto);

    Page<Map<String, Object>> selectGZNoticeDetailList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamForDetailDto dpFilterParamDto);

    Page<Map<String, Object>> selectYZNoticeDetailList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamForDetailDto dpFilterParamDto);

    List<Map<String, Object>> selectNoticeCountTopTen(@Param("orgCode") String orgCode, @Param("time") String time);

    /**
     *  告知类业务平均办理时效，统计维度：接收机构所在的行政区域;
     *  由于告知类，接收机构为监管机构，receive_company_org_code为监管机构的orgCode，故还保持使用receive_company_org_code匹配orgCode即可
     * @param dpFilterParamDto 过滤条件
     * @param orgCode 登录人或者选择区域转换后的orgCode
     * @return  告知类业务平均办理时效
     */
    List<CountDto> queryNoticeAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode);

    List<CountDto> queryUseAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode);

    List<CountDto> queryChangeAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode);

    List<CountDto> queryDisableAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode);

    List<CountDto> queryCancelAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode);

    Page<Map<String, Object>> countBizFinishedNumForDPListSGGZ(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Page<Map<String, Object>> countBizFinishedNumForDPListSYDJ(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Page<Map<String, Object>> countBizFinishedNumForDPListBGDJ(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Page<Map<String, Object>> countBizFinishedNumForDPListTYQY(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Page<Map<String, Object>> countBizFinishedNumForDPListZXBF(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Page<Map<String, Object>> countBizFinishedNumForDPListAll(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Long getNoticeCountTopChart(@Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    Page<Map<String, Object>> noticeCountTopPageNew(@Param("page") Page<Map<String, Object>> page, @Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    List<Map<String, Object>> noticeCountTopPageByUseUnitCode(@Param("unitCodeList") List<String> unitCodeList, @Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);
}
