package com.yeejoin.amos.boot.module.tcm.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 派遣任务
 *
 * @author kongfm
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_dispatch_task")
public class DispatchTask extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 是否救援任务
     */
	@TableField("is_save_task")
    private Boolean isSaveTask;

    /**
     * 警情id
     */
	@TableField("alert_id")
    private Long alertId;

    /**
     * 派遣单id
     */
	@TableField("paper_id")
    private Long paperId;

    /**
     * 组织code
     */
	@TableField("org_code")
    private String orgCode;

    /**
     * 派遣单位类型
     */
	@TableField("org_type")
    private String orgType;

    /**
     * 派遣单位类型code 使用单位/维保单位/三级响应
     */
	@TableField("org_type_code")
    private String orgTypeCode;

    /**
     * 响应单位id
     */
	@TableField("response_org_id")
    private String responseOrgId;

    /**
     * 响应单位名称
     */
	@TableField("response_org_name")
    private String responseOrgName;

    /**
     * 响应人员id
     */
	@TableField("response_user_id")
    private Long responseUserId;

    /**
     * 响应人员名称
     */
	@TableField("response_user_name")
    private String responseUserName;

    /**
     * 响应人员电话
     */
	@TableField("response_user_tel")
    private String responseUserTel;

    /**
     * 派遣时间
     */
	@TableField("dispatch_time")
    private Date dispatchTime;

    /**
     * 通知方式
     */
	@TableField("dispatch_info_type")
    private String dispatchInfoType;

    /**
     * 通知方式code
     */
	@TableField("dispatch_info_code")
    private String dispatchInfoCode;

    /**
     * 派遣内容
     */
	@TableField("dispatch_context")
    private String dispatchContext;

    /**
     * 到达时间
     */
	@TableField("arrive_time")
    private Date arriveTime;

    /**
     * 任务状态
     */
	@TableField("task_status")
    private String taskStatus;


    /**
     * 救援完成时间
     */
    @TableField("save_time")
	private Date saveTime;

}
