package com.yeejoin.amos.api.openapi.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 锅炉
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SpecialBoilerModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 设备唯一编码
     */
    private String sequenceCode;
    /**
     * 设计工作压力（MPa）
     */
    private String designUsePressure;
    /**
     * 许可工作压力（MPa）
     */
    private String permitUsePressure;
    /**
     * 额定出力（t/h）
     */
    private String ratedOutput;
    /**
     * 介质出口温度（℃）
     */
    private String mediumOutletTemperature;
    /**
     * 加热方式
     */
    private String heatingMode;
    /**
     * 燃料种类
     */
    private String fuelType;
    /**
     * 锅炉用途
     */
    private String boilerUse;
    /**
     * 燃烧方式
     */
    private String combustionMode;
    /**
     * 水处理方式
     */
    private String waterHandleMode;
    /**
     * 除氧方式
     */
    private String deaerationMode;
    /**
     * 出渣方式
     */
    private String slaggingMode;
    /**
     * 消烟除尘方式
     */
    private String eliminationzDustMode;
    /**
     * 单位司炉数量(人)
     */
    private String unitStokerNum;
    /**
     * 水质人员数量(人)
     */
    private String waterQualityUseNum;
    /**
     * 最大连续蒸发量(t/h)
     */
    private String maxContinuousEvaporation;
    /**
     * 再热蒸汽流量(t/h)
     */
    private String reheatSteamFlow;
    /**
     * 锅筒工作压力(MPa)
     */
    private String drumWorkingPressure;
    /**
     * 过热器出口压力(MPa)
     */
    private String superheaterOutletPressure;
    /**
     * 再热器入口压力(MPa)
     */
    private String reheaterInletPressure;
    /**
     * 再热器出口压力(MPa)
     */
    private String reheaterOutletPressure;
    /**
     * 给水温度（℃）
     */
    private String waterTemperature;
    /**
     * 过热器出口温度（℃）
     */
    private String superheaterOutletTemperature;
    /**
     * 再热器入口温度（℃）
     */
    private String reheaterInletTemperature;
    /**
     * 再热器出口温度（℃）
     */
    private String reheaterOutletTemperature;
    /**
     * 直流锅炉启动压力（MPa）
     */
    private String directBoilerStartingPressure;
    /**
     * 直流锅炉启动流量
     */
    private String directBoilerStartingFlow;
    /**
     * 水循环方式
     */
    private String waterCirculationMode;
    /**
     * 燃烧器布置方式
     */
    private String burnerLayoutMode;
    /**
     * 设计燃料可燃基挥发份
     */
    private String designFuelCombustibleVolatile;
    /**
     * 设计应用基低位发热值
     */
    private String designAppLowCalorificValue;
    /**
     * 设计应用基低位发热值单位
     */
    private String designAppLowCalorificValueUnit;
    /**
     * 补给水处理方式
     */
    private String waterSupplyTreatmentMode;
    /**
     * 过热蒸汽调温方式
     */
    private String overheatedSteamTemperatureRegulationMode;
    /**
     * 再热蒸汽调温方式
     */
    private String reheatSteamTemperatureRegulationMode;
    /**
     * 锅炉汽水分离方式
     */
    private String boilerSodaSeparateMode;

}
