package com.yeejoin.amos.boot.module.common.biz.service.impl;

import java.util.List;

import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DutyPersonShiftDto;
import com.yeejoin.amos.boot.module.common.api.entity.DutyPersonShift;
import com.yeejoin.amos.boot.module.common.api.mapper.DutyPersonShiftMapper;
import com.yeejoin.amos.boot.module.common.api.service.IDutyPersonShiftService;

/**
 * 值班人员日期关联关系表服务实现类
 *
 * @author system_generator
 * @date 2021-07-06
 */
@Service
public class DutyPersonShiftServiceImpl extends BaseService<DutyPersonShiftDto, DutyPersonShift, DutyPersonShiftMapper> implements IDutyPersonShiftService {
    /**
     * 分页查询
     */
    public Page<DutyPersonShiftDto> queryForDutyPersonShiftPage(Page<DutyPersonShiftDto> page) {
        return this.queryForPage(page, null, false);
    }



    /**
     * 列表查询 示例
     */
    public List<DutyPersonShiftDto> queryForDutyPersonShiftList() {
        return this.queryForList("", false);
    }
    
    /**
     * 查询指定的班次是否被关联使用
     * @return
     */
    public boolean checkCurrentDutyIsUser(Long shiftId) {
    	LambdaQueryWrapper<DutyPersonShift> wrapper= new LambdaQueryWrapper<DutyPersonShift>();
    	wrapper.eq(DutyPersonShift::getIsDelete, false);
    	wrapper.eq(DutyPersonShift::getShiftId, shiftId);
    	List<DutyPersonShift> list =	this.baseMapper.selectList(wrapper);
    	if(list!=null && list.size()>0) {
    		return true;
    	}
    	return false;
    }
}
