package com.yeejoin.amos.boot.module.jg.api.dto;

import lombok.Getter;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.nio.file.Files;

@Getter
public class ByteArrayMultipartFile implements MultipartFile {

    private byte[] bytes;
    private String name;
    private String originalFilename;
    private String contentType;


    public ByteArrayMultipartFile() {
    }

    public ByteArrayMultipartFile(String name, String originalFilename, String contentType, byte[] bytes) {
        super();
        this.name = name;
        this.originalFilename = originalFilename;
        this.contentType = contentType;
        this.bytes = bytes;
    }

    @Override
    public boolean isEmpty() {
        return bytes.length == 0;
    }

    @Override
    public long getSize() {
        return bytes.length;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public void transferTo(File destination) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(destination.toPath())) {
            outputStream.write(bytes);
        }
    }
}
