package com.yeejoin.amos.boot.module.statistcs.biz.init;

import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.JGDPStatisticsServiceImpl;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.StCommonServiceImpl;
import com.yeejoin.amos.component.robot.AmosRequestContext;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.context.RequestContext;

/**
 * @author Administrator
 */
@Component
public class DataInitAfterRuning implements ApplicationRunner {


    private StCommonServiceImpl stCommonService;
    private JGDPStatisticsServiceImpl jgdpStatisticsService;

    private AmosRequestContext amosRequestContext;

    public DataInitAfterRuning(StCommonServiceImpl stCommonService, AmosRequestContext amosRequestContext, JGDPStatisticsServiceImpl jgdpStatisticsService) {
        this.stCommonService = stCommonService;
        this.amosRequestContext = amosRequestContext;
        this.jgdpStatisticsService = jgdpStatisticsService;
    }

    @Override
    public void run(ApplicationArguments args) {
        // 初始化数据到内存
        RequestContext.setAppKey(amosRequestContext.getAppKey());
        RequestContext.setProduct(amosRequestContext.getProduct());
        RequestContext.setToken(amosRequestContext.getToken());
        stCommonService.init();
        jgdpStatisticsService.init();
    }
}
