package com.yeejoin.amos.boot.module.tcm.flc.biz.controller;

import com.yeejoin.amos.boot.module.tcm.flc.biz.service.impl.CylinderUnloadFakeServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;

import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tcm.flc.api.dto.CylinderUnloadFakeDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 卸液数据表-假数据
 *
 * @author system_generator
 * @date 2022-03-09
 */
@RestController
@Api(tags = "卸液数据表-假数据Api")
@RequestMapping(value = "/cylinder-unload-fake")
public class CylinderUnloadFakeController extends BaseController {

    @Autowired
    CylinderUnloadFakeServiceImpl cylinderUnloadFakeServiceImpl;

    /**
     * 新增卸液数据表-假数据
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增卸液数据表-假数据", notes = "新增卸液数据表-假数据")
	public ResponseModel<CylinderUnloadFakeDto> save(@RequestBody CylinderUnloadFakeDto model) {
	    model = cylinderUnloadFakeServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新卸液数据表-假数据", notes = "根据sequenceNbr更新卸液数据表-假数据")
	public ResponseModel<CylinderUnloadFakeDto> updateBySequenceNbrCylinderUnloadFake(@RequestBody CylinderUnloadFakeDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(cylinderUnloadFakeServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除卸液数据表-假数据", notes = "根据sequenceNbr删除卸液数据表-假数据")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(cylinderUnloadFakeServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个卸液数据表-假数据",  notes = "根据sequenceNbr查询单个卸液数据表-假数据")
	public ResponseModel<CylinderUnloadFakeDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(cylinderUnloadFakeServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "卸液数据表-假数据分页查询",  notes = "卸液数据表-假数据分页查询")
	public ResponseModel<Page<CylinderUnloadFakeDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<CylinderUnloadFakeDto> page = new Page<CylinderUnloadFakeDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(cylinderUnloadFakeServiceImpl.queryForCylinderUnloadFakePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "卸液数据表-假数据列表全部数据查询",   notes = "卸液数据表-假数据列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CylinderUnloadFakeDto>> selectForList() {
	    return ResponseHelper.buildResponse(cylinderUnloadFakeServiceImpl.queryForCylinderUnloadFakeList());
	}
}
