package com.yeejoin.amos.maintenance.core.framework;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.maintenance.exception.PermissionException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseBody;
import org.typroject.tyboot.core.foundation.context.RequestContext;

/**
 * @author DELL
 */
@Aspect
@Component
@ResponseBody
@Order(value = 1)
public class PersonIdentifyAspect {

    @Autowired
    RedisUtils redisUtils;

    @Before(value = "@annotation(com.yeejoin.amos.maintenance.core.framework.PersonIdentify) && @annotation(permission)")
    public void personIdentity(JoinPoint joinPoint, PersonIdentify permission) throws PermissionException {
        ReginParams reginParam = JSON.parseObject(redisUtils.get(buildKey(RequestContext.getToken())).toString(), ReginParams.class);
        if (permission.isNeedIdentity() && reginParam != null) {
            //调用jcs，进行人员身份判断，是维保公司人员还是业主单位人员
//            JSONObject result = new JSONObject();
//            String identityType = result.get("identityType").toString();
//            String personSeq = result.get("personSeq").toString();
//            String personName = result.get("personName").toString();
//            String companyId = result.get("companyId").toString();
            String identityType = "1";
            String personSeq = "1421016571081420802";
            String personName = "SHG";
            String companyId = "1420727427956502529";
            reginParam.setPersonIdentity(new ReginParams.PersonIdentity(identityType, personSeq, personName, companyId));
            redisUtils.set(buildKey(RequestContext.getToken()), JSONObject.toJSONString(reginParam));
        }
    }

    public String buildKey(String token) {
        return "region_" + token;
    }

}
