package com.yeejoin.amos.api.openapi.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class UsePlaceConverter implements Converter<String> {

    private static final Map<String, String> dictMap = new HashMap<>();

    static {
        dictMap.put("游乐场所", "6532");
        dictMap.put("商业单位", "6009");
        dictMap.put("学校", "6010");
        dictMap.put("政府机关", "6012");
        dictMap.put("医疗机构", "6011");
        dictMap.put("公共场所", "6013");
        dictMap.put("旅游景区", "6531");
        dictMap.put("住宅小区", "6008");
        dictMap.put("养老机构", "6530");
        dictMap.put("工业场所", "6528");
        dictMap.put("工业场所（户外）", "6529");
        dictMap.put("地铁站", "6641");
        dictMap.put("机场", "6642");
        dictMap.put("车站", "6643");
        dictMap.put("大型商业综合体", "6644");
        dictMap.put("商业综合体", "6644");
        dictMap.put("超市", "6645");
        dictMap.put("餐饮场所", "6646");
        dictMap.put("其他", "6647");
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        // 实体类中对象属性类型
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                    GlobalConfiguration globalConfiguration) {
        // 从Cell中读取数据
        String cellValue = cellData.getStringValue();
        // 判断Excel中的值，将其转换为预期的数值
        return dictMap.getOrDefault(cellValue, null);
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new CellData("");
    }

    public static void main(String[] args) {

    }
}