package com.yeejoin.amos.boot.module.jyjc.biz.event.listener;

import com.yeejoin.amos.boot.module.jyjc.api.model.InspectionEquipInfoModel;
import com.yeejoin.amos.boot.module.jyjc.biz.config.InspectionRuleEnableConfig;
import com.yeejoin.amos.boot.module.jyjc.biz.event.InspectionOrgRefreshEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.event.rule.RuleDataPrepareHandlerFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
@Slf4j
public class DataPreparationAdapterListener implements ApplicationListener<InspectionOrgRefreshEvent> {

    private final InspectionRuleEnableConfig inspectionRuleEnableConfig;

    private final RuleDataPrepareHandlerFactory handlerFactory;

    @Override
    public void onApplicationEvent(InspectionOrgRefreshEvent event) {
        InspectionEquipInfoModel equipInfoModel = event.getInspectionEquipInfoModel();
        Boolean enable = this.getEnableState(equipInfoModel.getInspectionType());
        handlerFactory.getRuleDataPrepare(enable).handle(event);
    }

    /**
     * 按照检验类型判断是否启用, 不配置时默认不启用
     *
     * @param inspectionType 检验类型枚举 @see JYJCTypeEnum
     * @return true-启用规则，false-不启用
     */
    private boolean getEnableState(String inspectionType) {
        return inspectionRuleEnableConfig.getValueByFieldName(inspectionType) != null && (Boolean) inspectionRuleEnableConfig.getValueByFieldName(inspectionType);
    }

}
