package com.yeejoin.amos.boot.module.jyjc.biz.message.open;

import com.yeejoin.amos.boot.module.jg.api.enums.WorkFlowStatusEnum;
import com.yeejoin.amos.boot.module.jyjc.biz.feign.MessageFeignClient;
import com.yeejoin.amos.feign.systemctl.model.MessageModel;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 资料校对受理已撤回-处理器
 */
@Component
@RequiredArgsConstructor
public class OpenAppReceiveRollbackMsgHandler implements IOpenApplicationMsgHandler{

    private final MessageFeignClient messageFeignClient;

    @Override
    public String supportState() {
        return WorkFlowStatusEnum.OPENING_APPLICATION_RECEIVE.getRollBack();
    }


    @Override
    public void handle(String userId, String relationId, String companyType) {
        // 按照relationId查询
        List<MessageModel> messageModels = messageFeignClient.listByRelationId(relationId + "1").getResult();
        // 查询结果删除接口
        if (!messageModels.isEmpty()) {
            messageFeignClient.delete(messageModels.stream().map(e -> String.valueOf(e.getSequenceNbr())).collect(Collectors.joining(",")));
        }
    }
}
