package com.yeejoin.amos.boot.module.statistcs.factory;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

import java.util.ArrayList;
import java.util.List;

public class DynamicQueryBuilder {
    private final List<QueryBuilder> shouldClauses = new ArrayList<>();
    private final List<QueryBuilder> mustClauses = new ArrayList<>();
    private final List<QueryBuilder> mustNotClauses = new ArrayList<>();

    // 添加OR条件
    public DynamicQueryBuilder or(QueryBuilder query) {
        shouldClauses.add(query);
        return this;
    }

    // 添加AND条件
    public DynamicQueryBuilder and(QueryBuilder query) {
        mustClauses.add(query);
        return this;
    }

    // 添加NOT条件
    public DynamicQueryBuilder not(QueryBuilder query) {
        mustNotClauses.add(query);
        return this;
    }

    // 构建最终查询
    public BoolQueryBuilder build() {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();

        if (!shouldClauses.isEmpty()) {
            shouldClauses.forEach(boolQuery::should);
            boolQuery.minimumShouldMatch(1);
        }

        mustClauses.forEach(boolQuery::must);
        mustNotClauses.forEach(boolQuery::mustNot);

        return boolQuery;
    }
}