package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.module.common.api.dto.ContraptionQueryParams;
import com.yeejoin.amos.boot.module.ymt.api.dto.ProjectWaitRefreshDataQualityScore;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgTechParamsPipeline;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 管道工程装置表 Mapper 接口
 *
 * @author system_generator
 * @date 2024-12-11
 */
public interface IdxBizJgProjectContraptionMapper extends BaseMapper<IdxBizJgProjectContraption> {

    Map<String, Object> getDetail(@Param("sequenceNbr") String sequenceNbr);

    List<Map<String, Object>> selectEquipList(@Param("sequenceNbr") String sequenceNbr);

    /**
     * 统计工程装置的引用次数（非待提交、非已撤回、非已驳回）
     *
     * @param projectContraptionIdList 工程装置唯一标识
     * @return 被引用次数 > 0 则设备不可编辑
     */
    List<Map<String, Integer>> countContraptionInUseTimesForEdit(@Param("projectContraptionIdList") List<Long> projectContraptionIdList);

    /**
     * 统计设备被引用的次数（只有存在就算引用-作废除外）
     *
     * @param projectContraptionIdList 设备唯一标识
     * @return 被引用次数 > 0 则设备不可删除
     */
    List<Map<String, Integer>> countContraptionInUseTimesForDelete(@Param("projectContraptionIdList") List<Long> projectContraptionIdList);

    /**
     * 获取管道信息总数
     *
     * @param projectContraptionIdList
     * @return
     */
    List<Map<String, Integer>> selectEquipCount(@Param("projectContraptionIdList") List<Long> projectContraptionIdList);

    /**
     * 获取不为空的检验信息个数
     */
    List<Map<String, Integer>> selectCheckCountByNotNull(@Param("projectContraptionIdList") List<Long> projectContraptionIdList);

    /**
     * 统计已纳管设备被引用的次数（只有存在就算引用-作废除外）
     *
     * @param projectContraptionId 设备唯一标识
     * @return 被引用次数 > 0 则设备不可删除
     */
    Integer countContraptionInUseTimesForDeleteByIntoManagement(@Param("projectContraptionId") String projectContraptionId);

    List<IdxBizJgProjectContraption> selectErrorManagementProject();


    /**
     * 查询检验的装置
     *
     * @param page           分页
     * @param queryParams    查询参数
     * @param companyCode    公司code
     * @return 分页
     */
    IPage<IdxBizJgProjectContraption> queryJgProjectContraptionPage(Page<IdxBizJgProjectContraption> page, @Param("params") ContraptionQueryParams queryParams, @Param("companyCode") String companyCode);

    /**
     * 获取管道信息分页
     *
     * @param sequenceNbr
     * @param current
     * @param size
     * @return
     */
    List<Map<String, Object>> selectEquipListPage(@Param("sequenceNbr") String sequenceNbr, @Param("current") int current, @Param("size") int size);

    /**
     * 获取指定装置下的管道信息-不包已报废的管道
     *
     * @param sequenceNbr  装置id
     * @return 装置下非报废状态的管道
     */
    List<Map<String, Object>> selectEquipListByExport(@Param("sequenceNbr") String sequenceNbr);

    /**
     * 统计已纳管设备被引用的次数（只有存在就算引用-作废除外）
     *
     * @param projectContraptionId 设备唯一标识
     * @return 被引用次数 > 0 则设备不可删除
     */
    List<Map<String, Integer>> countContraptionInUseTimesForDeleteByIntoManagementBatch(@Param("projectContraptionIdList") List<Long> projectContraptionIdList);

    /**
     * 获取管道信息分页
     *
     * @param sequenceNbr
     * @param current
     * @param size
     * @return
     */
    List<Map<String, Object>> selectPipelineListPage(@Param("sequenceNbr") String sequenceNbr, @Param("current") int current, @Param("size") int size);

    List<Map<String, Object>> selectPipelineList(@Param("equIds") List<String> equIds);

    void updateDataQualityScoreBatch(@Param("projectContraptions") List<ProjectWaitRefreshDataQualityScore> projectContraptions);

    List<IdxBizJgTechParamsPipeline> selectPipelineListByProjectContraptionId(@Param("projectContraptionId") String projectContraptionId);


    /**
     * 统计设备被引用的次数（只有存在就算引用-作废除外）
     *
     * @param projectContraptionIdList 装置唯一标识
     * @return 被引用次数 > 0 则设备不可删除
     */
    List<CountDto> countContraptionInUseTimesForDeleteBatch(@Param("projectContraptionIdList") List<String> projectContraptionIdList);

    List<Map<String, Object>> selectEquipListWithOutBf(String sequenceNbr);
}