package com.yeejoin.amos.api.householdapi.controller;

import com.yeejoin.amos.api.householdapi.Utils.GoodWeRequestUtil;
import com.yeejoin.amos.api.householdapi.Utils.HouseholdPvUtils;
import com.yeejoin.amos.api.householdapi.face.dto.GoodWEGenStation;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.*;
import com.yeejoin.amos.api.householdapi.face.service.*;
import com.yeejoin.amos.api.householdapi.face.service.business.*;
import com.yeejoin.amos.api.householdapi.face.service.impl.ImasterDataServiceImpl;
import com.yeejoin.amos.api.householdapi.face.service.impl.SofarDataAcquisitionServiceImpl;
import fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.io.IOException;


/**
 * 户用光伏-厂商API haders
 *
 * @author system_generator
 * @date 2023-06-07
 */
@RestController
@Api(tags = "测试")
@RequestMapping(value = "/household-pv-api-test1")
public class HouseholdTestController {
    @Autowired
    private HouseholdPvUtils householdPvUtils;
    @Autowired
    private GoLangDataAcquisitionService goLangDataAcquisitionService;
    @Autowired
    private KSolarDataAcquisitionService kSolarDataAcquisitionService;
    @Autowired
    private ImasterDataService imasterDataService;
    @Autowired
    private GoodWeDataAcquisitionService goodWeDataAcquisitionService;
    @Autowired
    private SofarDataAcquisitionService sofarDataAcquisitionService;





    @Autowired
    private TdHYGFInverterDayGenerateImpl tdHYGFInverterDayGenerateImpl;
    @Autowired
    private TdHYGFInverterMonthGenerateImpl tdHYGFInverterMonthGenerateImpl;
    @Autowired
    private TdHYGFInverterYearGenerateImpl tdHYGFInverterYearGenerateImpl;
    @Autowired
    private TdHYGFStationDayGenerateImpl tdHYGFStationDayGenerateImpl;
    @Autowired
    private TdHYGFStationMonthGenerateImpl tdHYGFStationMonthGenerateImpl;

    @Autowired
    private TdHYGFInverterTotalGenerateImpl tdHYGFInverterTotalGenerateImpl;
    @Autowired
    TdHYGFStationYearGenerateImpl tdHYGFStationYearGenerateImpl;

    //户用光伏日发电量
    @Autowired
    private HYGFJPDayPowerImpl hygfjpDayPowerImpl;

    @Autowired
    private HYGFJPStationPowerHistoryImpl hygfjpStationPowerHistoryImpl;

    @Autowired
    private HYGFJPInverterWarnImpl hygfjpInverterWarnImpl;





    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/goodweDemo")
    @ApiOperation(httpMethod = "POST", value = "固德威示例", notes = "固德威示例")
    public void goodweDemo() throws IOException {
     goodWeDataAcquisitionService.stationList();
//        goodWeDataAcquisitionService.stationDetail();
 //      goodWeDataAcquisitionService.inverAlramInfo();
//        goodWeDataAcquisitionService.inverterList();
//        goodWeDataAcquisitionService.inverterDetail();
//        goodWeDataAcquisitionService.stationMonthGen();
//        goodWeDataAcquisitionService.stationYearGen();
//        goodWeDataAcquisitionService.inverterDetail();
//        goodWeDataAcquisitionService.inverterMonthGen();
//        goodWeDataAcquisitionService.inverterYearGen();
    }

    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/golangnew")
    @ApiOperation(httpMethod = "POST", value = "锦浪云", notes = "锦浪云")
    public void golangnew() throws IOException {
//        goLangDataAcquisitionService.stationList();
//          goLangDataAcquisitionService.stationDetail();
//        goLangDataAcquisitionService.collectorList();
//        goLangDataAcquisitionService.inverterList();
//        goLangDataAcquisitionService.collectorDetail();
    //    goLangDataAcquisitionService.inverterDetail();
    //   goLangDataAcquisitionService.inverAlramInfo();

    }

    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/sofarnew")
    @ApiOperation(httpMethod = "POST", value = "首航", notes = "首航")
    public void sofarnew() throws IOException {
   //     sofarDataAcquisitionService.stationList();
//          goLangDataAcquisitionService.stationDetail();
//        goLangDataAcquisitionService.collectorList();
//        goLangDataAcquisitionService.inverterList();
//        goLangDataAcquisitionService.collectorDetail();
//        goLangDataAcquisitionService.inverterDetail();
        goLangDataAcquisitionService.inverAlramInfo();
    }

    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/goodWenew")
    @ApiOperation(httpMethod = "POST", value = "固德威", notes = "固德威")
    public void goodWenew() throws IOException {
//        goLangDataAcquisitionService.stationList();
//          goLangDataAcquisitionService.stationDetail();
//        goLangDataAcquisitionService.collectorList();
////        goLangDataAcquisitionService.inverterList();
//        goLangDataAcquisitionService.collectorDetail();
//        goLangDataAcquisitionService.inverterDetail();
//       goLangDataAcquisitionService.inverAlramInfo();
    }

    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/ksolarnew")
    @ApiOperation(httpMethod = "POST", value = "科士达", notes = "科士达")
    public void ksolarnew() throws IOException {
//        kSolarDataAcquisitionService.stationList();
//        kSolarDataAcquisitionService.stationList();
//        kSolarDataAcquisitionService.stationDetail();
//        kSolarDataAcquisitionService.collectorList();
//        kSolarDataAcquisitionService.collectorDetail();
////        goLangDataAcquisitionService.inverterList();
//        goLangDataAcquisitionService.collectorDetail();
       // goLangDataAcquisitionService.inverterDetail();
//        goLangDataAcquisitionService.inverAlramInfo();
        kSolarDataAcquisitionService.collectorList();

    }


    /**
     * 新增户用光伏-厂商API haders
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/imasterNew")
    @ApiOperation(httpMethod = "POST", value = "北向", notes = "北向")
    public void imasterNew() throws IOException {
//        imasterDataService.stationList();
//        imasterDataService.stationDetail();
        imasterDataService.collectorList();
//        imasterDataService.inverterList(null);
       // imasterDataService.inverterDetail(null);
        kSolarDataAcquisitionService.collectorDetail();
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping (value = "/updateAscription")
    @ApiOperation(httpMethod = "GET", value = "手动同步数据", notes = "手动同步数据")
    public void updateAscription(
            @RequestParam(value = "table",required=false) String table,//表名
            @RequestParam(value = "time",required=false) String time
    ){

        AscriptionService ascriptionService= this.updateAscriptionlist(table);
        ascriptionService.updateAscription(time);

    }


 public AscriptionService updateAscriptionlist( String table){

     AscriptionService ascriptionService=null;

     switch (table) {
         case "td_hygf_day_power":
             ascriptionService=hygfjpDayPowerImpl;
             break;
         case "td_hygf_jp_inverter_warn":
             ascriptionService=hygfjpInverterWarnImpl;
             break;
         case "td_hygf_jp_station_power_history":
             ascriptionService=hygfjpStationPowerHistoryImpl;
             break;
         case "td_hygf_station_day_generate":
             ascriptionService=tdHYGFStationDayGenerateImpl;
             break;
         case "td_hygf_station_month_generate":
             ascriptionService=tdHYGFStationMonthGenerateImpl;
             break;
         case "td_hygf_station_year_generate":
             ascriptionService=tdHYGFStationYearGenerateImpl;
             break;
         case "td_hygf_inverter_day_generate":
             ascriptionService=tdHYGFInverterDayGenerateImpl;
             break;
         case "td_hygf_inverter_month_generate":
             ascriptionService=tdHYGFInverterMonthGenerateImpl;
             break;
         case "td_hygf_inverter_year_generate":
             ascriptionService=tdHYGFInverterYearGenerateImpl;
             break;
         case "td_hygf_inverter_total_generate":
             ascriptionService=tdHYGFInverterTotalGenerateImpl;
             break;
         default:
             break;
     }

  return ascriptionService;
 }














}
