package com.yeejoin.amos.api.householdapi.face.service.business;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.HYGFJPDayPower;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.HYGFJPInverterWarn;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.HYGFJPInverterWarnMapper;
import com.yeejoin.amos.api.householdapi.face.service.AscriptionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2024/4/9
 */
@Service
public class HYGFJPInverterWarnImpl implements AscriptionService {
    @Autowired
    private JpStationMapper jpStationMapper;
    @Autowired
    private HYGFJPInverterWarnMapper hygfjpInverterWarnMapper;
    @Override
    public void updateAscription(String timeNum) {

        try {
        DateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        Date star = dft.parse(timeNum);//开始时间
        Date endDay= dft.parse(dft.format(new Date()));//结束时间
        Long starTime=star.getTime();
        Long endTime=endDay.getTime();
        Long num=endTime-starTime;//时间戳相差的毫秒数
        Long d= num/24/60/60/1000;
        int day=d.intValue();
        String sql="";
        if(day==0){
            sql=" and created_time>=TODAY() and created_time< TODAY() + 1d ";
        }else{
            sql=" and created_time>=TODAY() - "+day+"d and created_time< TODAY() - "+(day-1)+"d ";
        }

        List<HYGFJPInverterWarn> hygfjpDayPower = hygfjpInverterWarnMapper.selectList(
                new QueryWrapper<HYGFJPInverterWarn>().last(sql)
                        .and(wrapper -> {
                            wrapper.isNull("regional_companies_code")
                                    .or()
                                    .isNull("amos_company_code")
                                    .or()
                                    .isNull("station_name")
                                    .or()
                                    .isNull("station_state");
                        })
        );

        if(hygfjpDayPower!=null&&!hygfjpDayPower.isEmpty()){
            for (HYGFJPInverterWarn dayPower : hygfjpDayPower) {
                JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().
                        eq("third_station_id", dayPower.getThirdStationId()));
                if(jpStation!=null) {
                    dayPower.setAmosCompanyCode(jpStation.getAmosCompanyCode());
                    dayPower.setRegionalCompaniesCode(jpStation.getRegionalCompaniesCode());
                    dayPower.setStationName(jpStation.getName());
                    dayPower.setStationState(jpStation.getState());
                    hygfjpInverterWarnMapper.insert(dayPower);
                }
            }
        }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }



}
