package com.yeejoin.amos.boot.module.jxiop.biz.kafka;

import cn.hutool.core.date.DateUtil;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Value;

import java.util.Date;

public class KafkaConstant {



    @Value("${last.month.num:12}")
    public Integer lastMonthNum = 12;
    String startTime = DateUtils.convertDateToString(DateUtil.offsetMonth(new Date(), -lastMonthNum), DateUtils.DATE_TIME_PATTERN);
    String endTime = DateUtils.convertDateToString(DateUtils.getCurrentDayEndTime(new Date()), DateUtils.DATE_TIME_PATTERN);

    // 相关性
    @Value("${base.url.XGX:http://139.9.171.247:8052/intelligent-analysis/working-condition-division}")
    public static final String baseUrlXGX = "http://139.9.171.247:8052/intelligent-analysis/correlation";

    // 工况划分
    @Value("${base.url.GKHF:http://139.9.171.247:8052/intelligent-analysis/working-condition-division}")
    public static final String baseUrlGKHF = "http://139.9.171.247:8052/intelligent-analysis/working-condition-division";

    @Value("${spring.kafka.consumer.max-poll-records:30}")
    public static final Integer threadNum = 30;

}
