package com.yeejoin.amos.boot.module.jxiop.biz.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.RegionNationWideDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ResultsData;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.SeriesData;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface MonitorService {
    /**
     * @param areaCode 区域编码
     * @return 全国运维数据
     * @Description 根据区域编码动态运维数据
     */
    IPage<Map<String, Object>> operationData(String areaCode);

    /**
     * @return Map<String, Object>
     * @Description 全国新能源接入情况
     */
    Map<String, Object> accessSituation();

    /**
     * @return Map<String, Object>
     * @Description 区域新能源接入情况
     */
    Map<String, Object> qyAccessSituation();

    /**
     * @return List<RegionNationWideDto>
     * @Description 获取全国数据
     */
    Map<String, Object> gettimedateyfdqs();

    /**
     * @return List<RegionNationWideDto>
     * @Description 获取区域数据
     */
    Map<String, Object> gettimedateyfd(String areaName);



    /**
     * @return List<RegionNationWideDto>
     * @Description 获取区域数据
     */
    Map<String, Object> gettimedateqyyfd(String areaName);

    /**
     * @Description 获取全国的发电量趋势
     * @return SeriesData
     */
    SeriesData getSeriesDataqg();

    /**
     * @Description 根据areaCode获取全国发电量趋势
     * @param areaCode 区域code
     * @return SeriesData
     */
    SeriesData getSeriesDataqy(String areaCode);

    /**
     * @Descripiton 根据入参动态获取社会贡献
     * @param areaCode 区域code
     * @return
     */
    Page<HashMap<String, String>> socialContribution(String areaCode);

    /**
     * @Description 根据入参动态获取发电量排名
     * @param day 参数类型用于判断是日发电小时数、月发电小时数、年发电小时数
     * @param type 类型 风电或者光伏
     * @param areaCode 区域code
     * @return
     */
    Page<Map<String, Object>> stationRanking(String day,String type,String  areaCode );

    /**
     * @Descritpion 根据入参动态获取风电站数据
     * @param stationId
     * @return
     */
    IPage<Map> getStationOverViewFanByStationId( String stationId);
    /**
     * @Descritpion 根据入参动态获取全国发电量数据
     * @return
     */
    Map<String,Object> gettimedateyfd( );
    /**
     * @Descritpion 根据入参动态获取光伏站数据
     * @param stationId
     * @return
     */
    IPage<Map> getStationOverViewPVByStationId( String stationId);

    /**
     * @Description 动态获取电量表计数据
     * @param current
     * @param size
     * @param stationBasic
     * @return
     */
    ResultsData getElectricQuantityList(int current, int size, StationBasic stationBasic);

    /**
     * @Description 动态获取电量表计数据
     */
    void getTotalData();

    /**
     * @Description 获取全国功率曲线
     * @return
     */
    Map<String, Object> getDetailsWindSpeedAlldataqg();

}
