package com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.typeHandler.DictTypeHandler;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 业务字典处理器
 */
@Component("equipCategoryDictTypeHandler")
@RequiredArgsConstructor
public class EquipCategoryDictTypeHandler implements DictTypeHandler {

    private final EquipmentCategoryMapper equipmentCategoryMapper;;

    private final Map<String, String> cache = new ConcurrentHashMap<>();

    // dictType 未用到
    @Override
    public String handle(String dictType, String dictCode) {
        if (StringUtils.isEmpty(dictCode)) {
            return null;
        }
        // 汉字不做转化
        if (!dictCode.isEmpty() && dictCode.matches("^[\\u4e00-\\u9fa5]+$")){
            return dictCode;
        }
        return cache.computeIfAbsent(dictCode, (k) -> {
            LambdaQueryWrapper<EquipmentCategory> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(EquipmentCategory::getCode, dictCode);
            EquipmentCategory equipmentCategory = equipmentCategoryMapper.selectOne(wrapper);
            return Optional.ofNullable(equipmentCategory).map(EquipmentCategory::getName).orElse(null);
        });
    }


}
