package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.newEquip;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.CommonEquipDataProcessService;
import com.yeejoin.amos.boot.module.jg.biz.reminder.dto.MatchItemDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgRegisterInfoServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgUseInfoServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import static com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgRegisterInfoServiceImpl.*;

@Component
@RequiredArgsConstructor
@Getter
public class NewEquipParseService {
    private final IdxBizJgUseInfoServiceImpl idxBizJgUseInfoService;

    private final IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoService;

    private final CommonEquipDataProcessService equipDataProcessService;

    public String getRegTypeForEdit(String record) {
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOneData(record);
        String dataSource = useInfo.getDataSource();
        if (dataSource.contains("jg_his_black")) {
            return "2";
        } else if (dataSource.contains("jg_his")) {
            return "1";
        } else {
            return "0";
        }
    }

    public String getRegTypeForInsert(Map<String, Object> formData) {
        LinkedHashMap equipmentInfoForm = (LinkedHashMap) checkAndCast(formData.get(EQUIP_INFO_FORM_ID));
        String dataSource = equipmentInfoForm.get("DATA_SOURCE").toString();
        return "new".equals(dataSource) ? "0" : "his".equals(dataSource) ? "1" : "2";
    }

    public void setEquCateInfoForInsert(Map<String, Object> formData, MatchItemDto matchItemDto) {
        LinkedHashMap equipmentClassForm = (LinkedHashMap) checkAndCast(formData.get(EQUIP_CLASS_FORM_ID));
        String equListCode = (String) equipmentClassForm.get("EQU_LIST");
        String equCategoryCode = (String) equipmentClassForm.get("EQU_CATEGORY");
        String equDefineCode = (String) equipmentClassForm.get("EQU_DEFINE");
        String whetherVehicleCylinder = equipmentClassForm.get("WHETHER_VEHICLE_CYLINDER") != null ? (String) equipmentClassForm.get("WHETHER_VEHICLE_CYLINDER") : "0";
        matchItemDto.setEquList(equListCode);
        matchItemDto.setEquCategory(equCategoryCode);
        matchItemDto.setEquDefine(equDefineCode);
        matchItemDto.setWhetherVehicleCylinder(whetherVehicleCylinder);
    }

    public void setEquCateInfoForEdit(String record, MatchItemDto matchItemDto) {
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoService.getOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>()
                .eq(IdxBizJgRegisterInfo::getRecord, record)
                .select(TzsBaseEntity::getSequenceNbr,
                        IdxBizJgRegisterInfo::getRecord,
                        IdxBizJgRegisterInfo::getEquCategory,
                        IdxBizJgRegisterInfo::getEquDefine,
                        IdxBizJgRegisterInfo::getEquList,
                        IdxBizJgRegisterInfo::getWhetherVehicleCylinder));
        matchItemDto.setEquList(registerInfo.getEquList());
        matchItemDto.setEquCategory(registerInfo.getEquCategory());
        matchItemDto.setEquDefine(registerInfo.getEquDefine());
        matchItemDto.setWhetherVehicleCylinder(StringUtils.isNotEmpty(registerInfo.getWhetherVehicleCylinder()) ? registerInfo.getWhetherVehicleCylinder() : "0");
    }

    private Object checkAndCast(Object obj) {
        if (obj instanceof LinkedHashMap) {
            return obj;
        } else {
            throw new ClassCastException("对象类型不匹配");
        }
    }

    public Map<String, Object> getEquipDetailByRecord(String record) {
        return equipDataProcessService.getEquipDetailByRecord(record);
    }


    public Map<String, Object> getDetailInfoFromJson(Map<String, Object> formData) {
        Map<String, Object> re = new HashMap<>();
        LinkedHashMap equipmentInfoForm = (LinkedHashMap) checkAndCast(formData.get(EQUIP_INFO_FORM_ID));
        LinkedHashMap equipmentParamsForm = (LinkedHashMap) checkAndCast(formData.get(EQUIP_PARAMS_FORM_ID));
        re.putAll(equipmentInfoForm);
        re.putAll(equipmentParamsForm);
        return re;
    }

    public Boolean getIsRegister(String bizId) {
        if (StringUtils.isEmpty(bizId)) {
            return false;
        }
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOne(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, bizId).select(IdxBizJgUseInfo::getRecord, IdxBizJgUseInfo::getIsIntoManagement));
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoService.getOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, bizId).select(IdxBizJgRegisterInfo::getRecord, IdxBizJgRegisterInfo::getUseOrgCode));
        return useInfo.getIsIntoManagement() && StringUtils.isNotEmpty(registerInfo.getUseOrgCode());
    }
}
