package com.yeejoin.equipmanage.common.dto;

import com.yeejoin.equipmanage.common.entity.FireFightingSystemGroupEntity;
import com.yeejoin.equipmanage.common.entity.publics.BaseDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class FireFightingSystemGroupDto extends BaseDTO<FireFightingSystemGroupEntity> {

    @ApiModelProperty(value = "分组名称")
    private String groupName;

    @ApiModelProperty(value = "分组编码")
    private String groupCode;

    @ApiModelProperty(value = "展示类型：0-系统部件 1-安措")
    private Integer showType;

    @ApiModelProperty(value = "系统ID")
    private String systemIds;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "分组排序")
    private Integer sort;

    @ApiModelProperty(value = "业务组织编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "业务组织名称")
    private String bizOrgName;

    @ApiModelProperty(value = "系统与系统部件")
    private List<SystemEquipmentRelationDto> systemEquipmentRelations;
}
